/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class CreateTables<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<TableDestination, ElementT>>> {
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryServices bqServices;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final String kmsKey;
    private static Set<String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());

    public CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations, null);
    }

    private CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, BigQueryServices bqServices, DynamicDestinations<?, DestinationT> dynamicDestinations, String kmsKey) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
        this.kmsKey = kmsKey;
    }

    CreateTables<DestinationT, ElementT> withKmsKey(String kmsKey) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, this.bqServices, this.dynamicDestinations, kmsKey);
    }

    CreateTables<DestinationT, ElementT> withTestServices(BigQueryServices bqServices) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, bqServices, this.dynamicDestinations, this.kmsKey);
    }

    public PCollection<KV<TableDestination, ElementT>> expand(PCollection<KV<DestinationT, ElementT>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new CreateTablesFn()).withSideInputs((Iterable)sideInputs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearCreatedTables() {
        Set<String> set = createdTables;
        synchronized (set) {
            createdTables.clear();
        }
    }

    private class CreateTablesFn
    extends DoFn<KV<DestinationT, ElementT>, KV<TableDestination, ElementT>> {
        private Map<DestinationT, TableDestination> destinations;

        private CreateTablesFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.destinations = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            CreateTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
            context.output((Object)KV.of((Object)this.destinations.computeIfAbsent(((KV)context.element()).getKey(), dest -> this.getTableDestination(context, dest)), (Object)((KV)context.element()).getValue()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TableDestination getTableDestination(DoFn.ProcessContext context, DestinationT destination) {
            TableDestination tableDestination = CreateTables.this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)CreateTables.this.dynamicDestinations, destination);
            Preconditions.checkArgument((tableDestination.getTableSpec() != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() must return a TableDestination with a non-null table spec, but %s returned %s for destination %s,which has a null table spec", (Object)CreateTables.this.dynamicDestinations, (Object)tableDestination, destination);
            boolean destinationCoderSupportsClustering = !(CreateTables.this.dynamicDestinations.getDestinationCoder() instanceof TableDestinationCoderV2);
            Preconditions.checkArgument((tableDestination.getClustering() == null || destinationCoderSupportsClustering ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may only return destinations with clustering configured if a destination coder is supplied that supports clustering, but %s is configured to use TableDestinationCoderV2. Set withClustering() on BigQueryIO.write() and,  if you provided a custom DynamicDestinations instance, override getDestinationCoder() to return TableDestinationCoderV3.", (Object)CreateTables.this.dynamicDestinations);
            TableReference tableReference = tableDestination.getTableReference().clone();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                tableReference.setProjectId(((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class)).getProject());
                tableDestination = tableDestination.withTableReference(tableReference);
            }
            if (CreateTables.this.createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                return tableDestination;
            }
            String tableSpec = BigQueryHelpers.stripPartitionDecorator(tableDestination.getTableSpec());
            if (!createdTables.contains(tableSpec)) {
                Set set = createdTables;
                synchronized (set) {
                    if (!createdTables.contains(tableSpec)) {
                        this.tryCreateTable(context, destination, tableDestination, tableSpec, CreateTables.this.kmsKey);
                    }
                }
            }
            return tableDestination;
        }

        private void tryCreateTable(DoFn.ProcessContext context, DestinationT destination, TableDestination tableDestination, String tableSpec, String kmsKey) {
            BigQueryServices.DatasetService datasetService = CreateTables.this.bqServices.getDatasetService((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class));
            TableReference tableReference = tableDestination.getTableReference().clone();
            tableReference.setTableId(BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
            try {
                if (datasetService.getTable(tableReference) == null) {
                    TableSchema tableSchema = CreateTables.this.dynamicDestinations.getSchema(destination);
                    Preconditions.checkArgument((tableSchema != null ? 1 : 0) != 0, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and  %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)CreateTables.this.createDisposition), (Object)CreateTables.this.dynamicDestinations, destination);
                    Table table = new Table().setTableReference(tableReference).setSchema(tableSchema).setDescription(tableDestination.getTableDescription());
                    if (tableDestination.getTimePartitioning() != null) {
                        table.setTimePartitioning(tableDestination.getTimePartitioning());
                        if (tableDestination.getClustering() != null) {
                            table.setClustering(tableDestination.getClustering());
                        }
                    }
                    if (kmsKey != null) {
                        table.setEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
                    }
                    datasetService.createTable(table);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            createdTables.add(tableSpec);
        }
    }
}

