/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.healthcare.v1beta1.model.Message;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

public class HL7v2Message {
    private static final String schematizedDataKey = "schematizedData";
    private static final String schematizedDataPrefix = "{data=";
    private final String name;
    private final String messageType;
    private final String sendTime;
    private final String createTime;
    private final String data;
    private final String sendFacility;
    private String schematizedData;
    private final Map<String, String> labels;

    private static String extractDataJson(String schematizedData) {
        ObjectMapper mapper = new ObjectMapper();
        String jsonData = schematizedData != null && schematizedData.startsWith(schematizedDataPrefix) && schematizedData.endsWith("}}") ? schematizedData.substring(schematizedDataPrefix.length(), schematizedData.length() - 1) : schematizedData;
        try {
            mapper.readTree(jsonData);
            return jsonData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not validate inner schematizedData JSON: %s", e.getMessage()));
        }
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return this.getData();
        }
    }

    public static HL7v2Message fromModel(Message msg) {
        String schematizedData = msg.get((Object)schematizedDataKey) != null ? HL7v2Message.extractDataJson(msg.get((Object)schematizedDataKey).toString()) : null;
        return new HL7v2Message(msg.getName(), msg.getMessageType(), msg.getSendTime(), msg.getCreateTime(), msg.getData(), msg.getSendFacility(), schematizedData, msg.getLabels());
    }

    public static HL7v2Message fromMap(Map msg) {
        String schematizedData = msg.get(schematizedDataKey) != null ? HL7v2Message.extractDataJson(msg.get(schematizedDataKey).toString()) : null;
        return new HL7v2Message(msg.get("name").toString(), msg.get("messageType").toString(), null, msg.get("createTime").toString(), msg.get("data").toString(), msg.get("sendFacility").toString(), schematizedData, null);
    }

    public Message toModel() {
        Message out = new Message();
        out.setName(this.getName());
        out.setMessageType(this.getMessageType());
        out.setSendTime(this.getSendTime());
        out.setCreateTime(this.getCreateTime());
        out.setData(this.getData());
        out.setSendFacility(this.getSendFacility());
        out.set(schematizedDataKey, (Object)this.getSchematizedData());
        out.setLabels(this.labels);
        return out;
    }

    public HL7v2Message(String name, String messageType, String sendTime, String createTime, String data, String sendFacility, @Nullable String schematizedData, @Nullable Map<String, String> labels) {
        this.name = name;
        this.messageType = messageType;
        this.sendTime = sendTime;
        this.createTime = createTime;
        this.data = data;
        this.sendFacility = sendFacility;
        this.schematizedData = schematizedData;
        this.labels = labels;
    }

    public String getName() {
        return this.name;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getData() {
        return this.data;
    }

    public String getSendFacility() {
        return this.sendFacility;
    }

    public String getSchematizedData() {
        return this.schematizedData;
    }

    public void setSchematizedData(String schematizedData) {
        this.schematizedData = schematizedData;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }
}

