/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.values.TypeDescriptor;

public class PubsubMessageWithAttributesCoder
extends CustomCoder<PubsubMessage> {
    private static final Coder<byte[]> PAYLOAD_CODER = ByteArrayCoder.of();
    private static final Coder<Map<String, String>> ATTRIBUTES_CODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));

    public static Coder<PubsubMessage> of(TypeDescriptor<PubsubMessage> ignored) {
        return PubsubMessageWithAttributesCoder.of();
    }

    public static PubsubMessageWithAttributesCoder of() {
        return new PubsubMessageWithAttributesCoder();
    }

    public void encode(PubsubMessage value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(PubsubMessage value, OutputStream outStream, Coder.Context context) throws IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream);
        ATTRIBUTES_CODER.encode(value.getAttributeMap(), outStream, context);
    }

    public PubsubMessage decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public PubsubMessage decode(InputStream inStream, Coder.Context context) throws IOException {
        byte[] payload = (byte[])PAYLOAD_CODER.decode(inStream);
        Map attributes = (Map)ATTRIBUTES_CODER.decode(inStream, context);
        return new PubsubMessage(payload, attributes);
    }
}

