/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;

class CreateTransactionFn
extends DoFn<Object, Transaction> {
    private final SpannerIO.CreateTransaction config;
    private transient SpannerAccessor spannerAccessor;

    CreateTransactionFn(SpannerIO.CreateTransaction config) {
        this.config = config;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = this.config.getSpannerConfig().connectToSpanner();
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        DatabaseClient databaseClient = this.spannerAccessor.getDatabaseClient();
        try (ReadOnlyTransaction readOnlyTransaction = databaseClient.readOnlyTransaction(this.config.getTimestampBound());){
            ResultSet resultSet = readOnlyTransaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            while (resultSet.next()) {
            }
            Transaction tx = Transaction.create(readOnlyTransaction.getReadTimestamp());
            c.output((Object)tx);
        }
    }
}

