/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.BaseEncoding;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class BigQueryAvroUtils {
    public static final ImmutableMap<String, Schema.Type> BIG_QUERY_TO_AVRO_TYPES = ImmutableMap.builder().put((Object)"STRING", (Object)Schema.Type.STRING).put((Object)"GEOGRAPHY", (Object)Schema.Type.STRING).put((Object)"BYTES", (Object)Schema.Type.BYTES).put((Object)"INTEGER", (Object)Schema.Type.LONG).put((Object)"FLOAT", (Object)Schema.Type.DOUBLE).put((Object)"NUMERIC", (Object)Schema.Type.BYTES).put((Object)"BOOLEAN", (Object)Schema.Type.BOOLEAN).put((Object)"TIMESTAMP", (Object)Schema.Type.LONG).put((Object)"RECORD", (Object)Schema.Type.RECORD).put((Object)"DATE", (Object)Schema.Type.STRING).put((Object)"DATETIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.STRING).build();
    private static final DateTimeFormatter DATE_AND_SECONDS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();

    BigQueryAvroUtils() {
    }

    static String formatTimestamp(String timestamp) {
        double timestampDoubleMicros = Double.parseDouble(timestamp) * 1000000.0;
        long timestampMicros = (long)timestampDoubleMicros;
        long seconds = timestampMicros / 1000000L;
        int micros = (int)(timestampMicros % 1000000L);
        String dayAndTime = DATE_AND_SECONDS_FORMATTER.print(seconds * 1000L);
        if (micros == 0) {
            return String.format("%s UTC", dayAndTime);
        }
        int digits = 6;
        int subsecond = micros;
        while (subsecond % 10 == 0) {
            --digits;
            subsecond /= 10;
        }
        String formatString = String.format("%%0%dd", digits);
        String fractionalSeconds = String.format(formatString, subsecond);
        return String.format("%s.%s UTC", dayAndTime, fractionalSeconds);
    }

    static TableRow convertGenericRecordToTableRow(GenericRecord record, TableSchema schema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record, schema.getFields());
    }

    private static TableRow convertGenericRecordToTableRow(GenericRecord record, List<TableFieldSchema> fields) {
        TableRow row = new TableRow();
        for (TableFieldSchema subSchema : fields) {
            Schema.Field field = record.getSchema().getField(subSchema.getName());
            Object convertedValue = BigQueryAvroUtils.getTypedCellValue(field.schema(), subSchema, record.get(field.name()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    @Nullable
    private static Object getTypedCellValue(Schema schema, TableFieldSchema fieldSchema, Object v) {
        String mode;
        switch (mode = (String)MoreObjects.firstNonNull((Object)fieldSchema.getMode(), (Object)"NULLABLE")) {
            case "REQUIRED": {
                return BigQueryAvroUtils.convertRequiredField(schema.getType(), schema.getLogicalType(), fieldSchema, v);
            }
            case "REPEATED": {
                return BigQueryAvroUtils.convertRepeatedField(schema, fieldSchema, v);
            }
            case "NULLABLE": {
                return BigQueryAvroUtils.convertNullableField(schema, fieldSchema, v);
            }
        }
        throw new UnsupportedOperationException("Parsing a field with BigQuery field schema mode " + fieldSchema.getMode());
    }

    private static List<Object> convertRepeatedField(Schema schema, TableFieldSchema fieldSchema, Object v) {
        Schema.Type arrayType = schema.getType();
        Verify.verify((arrayType == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"BigQuery REPEATED field %s should be Avro ARRAY, not %s", (Object[])new Object[]{fieldSchema.getName(), arrayType});
        if (v == null) {
            return new ArrayList<Object>();
        }
        List elements = (List)v;
        ArrayList<Object> values = new ArrayList<Object>();
        Schema.Type elementType = schema.getElementType().getType();
        LogicalType elementLogicalType = schema.getElementType().getLogicalType();
        for (Object element : elements) {
            values.add(BigQueryAvroUtils.convertRequiredField(elementType, elementLogicalType, fieldSchema, element));
        }
        return values;
    }

    private static Object convertRequiredField(Schema.Type avroType, LogicalType avroLogicalType, TableFieldSchema fieldSchema, Object v) {
        Preconditions.checkNotNull((Object)v, (String)"REQUIRED field %s should not be null", (Object)fieldSchema.getName());
        String bqType = fieldSchema.getType();
        Schema.Type expectedAvroType = (Schema.Type)BIG_QUERY_TO_AVRO_TYPES.get((Object)bqType);
        Verify.verifyNotNull((Object)expectedAvroType, (String)"Unsupported BigQuery type: %s", (Object[])new Object[]{bqType});
        Verify.verify((avroType == expectedAvroType ? 1 : 0) != 0, (String)"Expected Avro schema type %s, not %s, for BigQuery %s field %s", (Object[])new Object[]{expectedAvroType, avroType, bqType, fieldSchema.getName()});
        switch (fieldSchema.getType()) {
            case "STRING": 
            case "DATE": 
            case "DATETIME": 
            case "TIME": 
            case "GEOGRAPHY": {
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", (Object[])new Object[]{v.getClass()});
                return v.toString();
            }
            case "INTEGER": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", (Object[])new Object[]{v.getClass()});
                return ((Long)v).toString();
            }
            case "FLOAT": {
                Verify.verify((boolean)(v instanceof Double), (String)"Expected Double, got %s", (Object[])new Object[]{v.getClass()});
                return v;
            }
            case "NUMERIC": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", (Object[])new Object[]{v.getClass()});
                Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected Decimal logical type", (Object[])new Object[0]);
                Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.Decimal), (String)"Expected Decimal logical type", (Object[])new Object[0]);
                BigDecimal numericValue = new Conversions.DecimalConversion().fromBytes((ByteBuffer)v, Schema.create((Schema.Type)avroType), avroLogicalType);
                return numericValue.toString();
            }
            case "BOOLEAN": {
                Verify.verify((boolean)(v instanceof Boolean), (String)"Expected Boolean, got %s", (Object[])new Object[]{v.getClass()});
                return v;
            }
            case "TIMESTAMP": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", (Object[])new Object[]{v.getClass()});
                Double doubleValue = (double)((Long)v).longValue() / 1000000.0;
                return BigQueryAvroUtils.formatTimestamp(doubleValue.toString());
            }
            case "RECORD": {
                Verify.verify((boolean)(v instanceof GenericRecord), (String)"Expected GenericRecord, got %s", (Object[])new Object[]{v.getClass()});
                return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)v, fieldSchema.getFields());
            }
            case "BYTES": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", (Object[])new Object[]{v.getClass()});
                ByteBuffer byteBuffer = (ByteBuffer)v;
                byte[] bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
                return BaseEncoding.base64().encode(bytes);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected BigQuery field schema type %s for field named %s", fieldSchema.getType(), fieldSchema.getName()));
    }

    @Nullable
    private static Object convertNullableField(Schema avroSchema, TableFieldSchema fieldSchema, Object v) {
        Verify.verify((avroSchema.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", (Object[])new Object[]{avroSchema.getType(), fieldSchema.getName()});
        List unionTypes = avroSchema.getTypes();
        Verify.verify((unionTypes.size() == 2 ? 1 : 0) != 0, (String)"BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", (Object[])new Object[]{fieldSchema.getName(), unionTypes});
        if (v == null) {
            return null;
        }
        Schema.Type firstType = ((Schema)unionTypes.get(0)).getType();
        if (!firstType.equals((Object)Schema.Type.NULL)) {
            return BigQueryAvroUtils.convertRequiredField(firstType, ((Schema)unionTypes.get(0)).getLogicalType(), fieldSchema, v);
        }
        return BigQueryAvroUtils.convertRequiredField(((Schema)unionTypes.get(1)).getType(), ((Schema)unionTypes.get(1)).getLogicalType(), fieldSchema, v);
    }

    static Schema toGenericAvroSchema(String schemaName, List<TableFieldSchema> fieldSchemas) {
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (TableFieldSchema bigQueryField : fieldSchemas) {
            avroFields.add(BigQueryAvroUtils.convertField(bigQueryField));
        }
        return Schema.createRecord((String)schemaName, (String)"org.apache.beam.sdk.io.gcp.bigquery", (String)("Translated Avro Schema for " + schemaName), (boolean)false, avroFields);
    }

    private static Schema.Field convertField(TableFieldSchema bigQueryField) {
        Schema fieldSchema;
        Schema.Type avroType = (Schema.Type)BIG_QUERY_TO_AVRO_TYPES.get((Object)bigQueryField.getType());
        Schema elementSchema = avroType == Schema.Type.RECORD ? BigQueryAvroUtils.toGenericAvroSchema(bigQueryField.getName(), bigQueryField.getFields()) : Schema.create((Schema.Type)avroType);
        if (bigQueryField.getMode() == null || "NULLABLE".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), elementSchema});
        } else if ("REQUIRED".equals(bigQueryField.getMode())) {
            fieldSchema = elementSchema;
        } else if ("REPEATED".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createArray((Schema)elementSchema);
        } else {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", bigQueryField.getMode()));
        }
        return new Schema.Field(bigQueryField.getName(), fieldSchema, bigQueryField.getDescription(), null);
    }
}

