/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.AbstractSpannerFn;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;

class CreateTransactionFn
extends AbstractSpannerFn<Object, Transaction> {
    private final SpannerIO.CreateTransaction config;

    CreateTransactionFn(SpannerIO.CreateTransaction config) {
        this.config = config;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        try (ReadOnlyTransaction readOnlyTransaction = this.databaseClient().readOnlyTransaction(this.config.getTimestampBound());){
            ResultSet resultSet = readOnlyTransaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            while (resultSet.next()) {
            }
            Transaction tx = Transaction.create(readOnlyTransaction.getReadTimestamp());
            c.output((Object)tx);
        }
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.config.getSpannerConfig();
    }
}

