/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;

final class AutoValue_SpannerIO_Write
extends SpannerIO.Write {
    private final SpannerConfig spannerConfig;
    private final long batchSizeBytes;

    private AutoValue_SpannerIO_Write(SpannerConfig spannerConfig, long batchSizeBytes) {
        this.spannerConfig = spannerConfig;
        this.batchSizeBytes = batchSizeBytes;
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.spannerConfig;
    }

    @Override
    long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerIO.Write) {
            SpannerIO.Write that = (SpannerIO.Write)((Object)o);
            return this.spannerConfig.equals(that.getSpannerConfig()) && this.batchSizeBytes == that.getBatchSizeBytes();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.spannerConfig.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.batchSizeBytes >>> 32 ^ this.batchSizeBytes));
        return h;
    }

    @Override
    SpannerIO.Write.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SpannerIO.Write.Builder {
        private SpannerConfig spannerConfig;
        private Long batchSizeBytes;

        Builder() {
        }

        private Builder(SpannerIO.Write source) {
            this.spannerConfig = source.getSpannerConfig();
            this.batchSizeBytes = source.getBatchSizeBytes();
        }

        @Override
        SpannerIO.Write.Builder setSpannerConfig(SpannerConfig spannerConfig) {
            if (spannerConfig == null) {
                throw new NullPointerException("Null spannerConfig");
            }
            this.spannerConfig = spannerConfig;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setBatchSizeBytes(long batchSizeBytes) {
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        SpannerIO.Write build() {
            String missing = "";
            if (this.spannerConfig == null) {
                missing = missing + " spannerConfig";
            }
            if (this.batchSizeBytes == null) {
                missing = missing + " batchSizeBytes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerIO_Write(this.spannerConfig, this.batchSizeBytes);
        }
    }
}

