/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.GenerateShardedTable;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKeyCoder;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteFn;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TagWithUniqueIds;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StreamingWriteTables
extends PTransform<PCollection<KV<TableDestination, TableRow>>, WriteResult> {
    private BigQueryServices bigQueryServices;

    public StreamingWriteTables() {
        this(new BigQueryServicesImpl());
    }

    private StreamingWriteTables(BigQueryServices bigQueryServices) {
        this.bigQueryServices = bigQueryServices;
    }

    StreamingWriteTables withTestServices(BigQueryServices bigQueryServices) {
        return new StreamingWriteTables(bigQueryServices);
    }

    public WriteResult expand(PCollection<KV<TableDestination, TableRow>> input) {
        PCollection tagged = (PCollection)((PCollection)input.apply("ShardTableWrites", (PTransform)ParDo.of((DoFn)new GenerateShardedTable(50)))).setCoder((Coder)KvCoder.of(ShardedKeyCoder.of(StringUtf8Coder.of()), (Coder)TableRowJsonCoder.of())).apply("TagWithUniqueIds", (PTransform)ParDo.of((DoFn)new TagWithUniqueIds()));
        ((PCollection)((PCollection)tagged.setCoder((Coder)KvCoder.of(ShardedKeyCoder.of(StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of())).apply((PTransform)Reshuffle.of())).apply("GlobalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("StreamingWrite", (PTransform)ParDo.of((DoFn)new StreamingWriteFn(this.bigQueryServices)));
        return WriteResult.in(input.getPipeline());
    }
}

