/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.Serializable;
import java.util.Objects;

class ShardedKey<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final K key;
    private final int shardNumber;

    public static <K> ShardedKey<K> of(K key, int shardNumber) {
        return new ShardedKey<K>(key, shardNumber);
    }

    ShardedKey(K key, int shardNumber) {
        this.key = key;
        this.shardNumber = shardNumber;
    }

    public K getKey() {
        return this.key;
    }

    public int getShardNumber() {
        return this.shardNumber;
    }

    public String toString() {
        return "key: " + this.key + " shard: " + this.shardNumber;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ShardedKey)) {
            return false;
        }
        ShardedKey other = (ShardedKey)o;
        return Objects.equals(this.key, other.key) && Objects.equals(this.shardNumber, other.shardNumber);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.shardNumber);
    }
}

