/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TransformingSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQuerySourceBase
extends BoundedSource<TableRow> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySourceBase.class);
    protected static final int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    protected final String stepUuid;
    protected final BigQueryServices bqServices;
    private transient List<BoundedSource<TableRow>> cachedSplitResult;

    BigQuerySourceBase(String stepUuid, BigQueryServices bqServices) {
        this.stepUuid = (String)Preconditions.checkNotNull((Object)stepUuid, (Object)"stepUuid");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
    }

    public List<BoundedSource<TableRow>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        if (this.cachedSplitResult == null) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableToExtract = this.getTableToExtract(bqOptions);
            BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
            String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", this.stepUuid);
            String extractJobId = BigQueryHelpers.getExtractJobId(BigQueryHelpers.createJobIdToken(options.getJobName(), this.stepUuid));
            List<ResourceId> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService, bqOptions.getProject(), extractDestinationDir);
            TableSchema tableSchema = this.bqServices.getDatasetService(bqOptions).getTable(tableToExtract).getSchema();
            this.cleanupTempResource(bqOptions);
            this.cachedSplitResult = (List)Preconditions.checkNotNull(this.createSources(tempFiles, tableSchema));
        }
        return this.cachedSplitResult;
    }

    protected abstract TableReference getTableToExtract(BigQueryOptions var1) throws Exception;

    protected abstract void cleanupTempResource(BigQueryOptions var1) throws Exception;

    public void validate() {
    }

    public Coder<TableRow> getDefaultOutputCoder() {
        return TableRowJsonCoder.of();
    }

    private List<ResourceId> executeExtract(String jobId, TableReference table, BigQueryServices.JobService jobService, String executingProject, String extractDestinationDir) throws InterruptedException, IOException {
        JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(jobId);
        String destinationUri = BigQueryIO.getExtractDestinationUri(extractDestinationDir);
        JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setDestinationUris((List)ImmutableList.of((Object)destinationUri));
        LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
        jobService.startExtractJob(jobRef, extract);
        Job extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
        if (BigQueryHelpers.parseStatus(extractJob) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Extract job %s failed, status: %s.", extractJob.getJobReference().getJobId(), BigQueryHelpers.statusToPrettyString(extractJob.getStatus())));
        }
        LOG.info("BigQuery extract job completed: {}", (Object)jobId);
        return BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob);
    }

    private List<BoundedSource<TableRow>> createSources(List<ResourceId> files, TableSchema tableSchema) throws IOException, InterruptedException {
        final String jsonSchema = BigQueryIO.JSON_FACTORY.toString((Object)tableSchema);
        SerializableFunction<GenericRecord, TableRow> function = new SerializableFunction<GenericRecord, TableRow>(){

            public TableRow apply(GenericRecord input) {
                return BigQueryAvroUtils.convertGenericRecordToTableRow(input, BigQueryHelpers.fromJsonString(jsonSchema, TableSchema.class));
            }
        };
        ArrayList avroSources = Lists.newArrayList();
        for (ResourceId file : files) {
            avroSources.add(new TransformingSource<GenericRecord, TableRow>((BoundedSource<GenericRecord>)AvroSource.from((String)file.toString()), function, this.getDefaultOutputCoder()));
        }
        return ImmutableList.copyOf((Collection)avroSources);
    }

    protected static class BigQueryReader
    extends BoundedSource.BoundedReader<TableRow> {
        private final BigQuerySourceBase source;
        private final BigQueryServices.BigQueryJsonReader reader;

        BigQueryReader(BigQuerySourceBase source, BigQueryServices.BigQueryJsonReader reader) {
            this.source = source;
            this.reader = reader;
        }

        public BoundedSource<TableRow> getCurrentSource() {
            return this.source;
        }

        public boolean start() throws IOException {
            return this.reader.start();
        }

        public boolean advance() throws IOException {
            return this.reader.advance();
        }

        public TableRow getCurrent() throws NoSuchElementException {
            return this.reader.getCurrent();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

