/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.values.KV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigtableServiceImpl
implements BigtableService {
    private static final Logger logger = LoggerFactory.getLogger(BigtableService.class);
    private final BigtableOptions options;

    public BigtableServiceImpl(BigtableOptions options) {
        this.options = options;
    }

    @Override
    public BigtableOptions getBigtableOptions() {
        return this.options;
    }

    @Override
    public BigtableWriterImpl openForWriting(String tableId) throws IOException {
        BigtableSession session = new BigtableSession(this.options);
        BigtableTableName tableName = this.options.getInstanceName().toTableName(tableId);
        return new BigtableWriterImpl(session, tableName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tableExists(String tableId) throws IOException {
        if (!BigtableSession.isAlpnProviderEnabled()) {
            logger.info("Skipping existence check for table {} (BigtableOptions {}) because ALPN is not configured.", (Object)tableId, (Object)this.options);
            return true;
        }
        try (BigtableSession session = new BigtableSession(this.options);){
            GetTableRequest getTable = GetTableRequest.newBuilder().setName(this.options.getInstanceName().toTableNameStr(tableId)).build();
            session.getTableAdminClient().getTable(getTable);
            boolean bl = true;
            return bl;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return false;
            }
            String message = String.format("Error checking whether table %s (BigtableOptions %s) exists", tableId, this.options);
            logger.error(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(BigtableServiceImpl.class).add("options", (Object)this.options).toString();
    }

    @Override
    public BigtableService.Reader createReader(BigtableIO.BigtableSource source) throws IOException {
        BigtableSession session = new BigtableSession(this.options);
        return new BigtableReaderImpl(session, source);
    }

    @Override
    public List<SampleRowKeysResponse> getSampleRowKeys(BigtableIO.BigtableSource source) throws IOException {
        try (BigtableSession session = new BigtableSession(this.options);){
            SampleRowKeysRequest request = SampleRowKeysRequest.newBuilder().setTableName(this.options.getInstanceName().toTableNameStr(source.getTableId())).build();
            ImmutableList immutableList = session.getDataClient().sampleRowKeys(request);
            return immutableList;
        }
    }

    private static class BigtableWriterImpl
    implements BigtableService.Writer {
        private BigtableSession session;
        private AsyncExecutor executor;
        private BulkMutation bulkMutation;
        private final MutateRowRequest.Builder partialBuilder;

        public BigtableWriterImpl(BigtableSession session, BigtableTableName tableName) {
            this.session = session;
            this.executor = session.createAsyncExecutor();
            this.bulkMutation = session.createBulkMutation(tableName, this.executor);
            this.partialBuilder = MutateRowRequest.newBuilder().setTableName(tableName.toString());
        }

        @Override
        public void flush() throws IOException {
            if (this.bulkMutation != null) {
                this.bulkMutation.flush();
                this.executor.flush();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.bulkMutation != null) {
                    this.bulkMutation.flush();
                    this.bulkMutation = null;
                    this.executor.flush();
                    this.executor = null;
                }
            }
            finally {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
        }

        @Override
        public ListenableFuture<MutateRowResponse> writeRecord(KV<ByteString, Iterable<Mutation>> record) throws IOException {
            MutateRowRequest r = this.partialBuilder.clone().setRowKey((ByteString)record.getKey()).addAllMutations((Iterable)record.getValue()).build();
            return this.bulkMutation.add(r);
        }
    }

    private class BigtableReaderImpl
    implements BigtableService.Reader {
        private BigtableSession session;
        private final BigtableIO.BigtableSource source;
        private ResultScanner<Row> results;
        private Row currentRow;

        public BigtableReaderImpl(BigtableSession session, BigtableIO.BigtableSource source) {
            this.session = session;
            this.source = source;
        }

        @Override
        public boolean start() throws IOException {
            RowRange range = RowRange.newBuilder().setStartKeyClosed(this.source.getRange().getStartKey().getValue()).setEndKeyOpen(this.source.getRange().getEndKey().getValue()).build();
            RowSet rowSet = RowSet.newBuilder().addRowRanges(range).build();
            ReadRowsRequest.Builder requestB = ReadRowsRequest.newBuilder().setRows(rowSet).setTableName(BigtableServiceImpl.this.options.getInstanceName().toTableNameStr(this.source.getTableId()));
            if (this.source.getRowFilter() != null) {
                requestB.setFilter(this.source.getRowFilter());
            }
            this.results = this.session.getDataClient().readRows(requestB.build());
            return this.advance();
        }

        @Override
        public boolean advance() throws IOException {
            this.currentRow = (Row)this.results.next();
            return this.currentRow != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.session == null) {
                return;
            }
            try (Closer closer = Closer.create();){
                if (this.results != null) {
                    closer.register(this.results);
                    this.results = null;
                }
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }

        @Override
        public Row getCurrentRow() throws NoSuchElementException {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }
    }
}

