/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryTableInserter {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableInserter.class);
    private final Bigquery client;
    private static final int RETRY_CREATE_TABLE_DURATION_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);

    BigQueryTableInserter(Bigquery client, PipelineOptions options) {
        this.client = client;
    }

    Table getOrCreateTable(TableReference ref, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable TableSchema schema) throws IOException {
        Table table;
        block9: {
            Bigquery.Tables.Get get = this.client.tables().get(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            table = null;
            try {
                table = (Table)get.execute();
            }
            catch (IOException e) {
                ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
                if (errorExtractor.itemNotFound(e) && createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED) break block9;
                throw e;
            }
        }
        if (table != null) {
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_APPEND) {
                return table;
            }
            boolean empty = this.isEmpty(ref);
            if (empty) {
                if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE) {
                    LOG.info("Empty table found, not removing {}", (Object)BigQueryIO.toTableSpec(ref));
                }
                return table;
            }
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_EMPTY) {
                throw new IOException("WriteDisposition is WRITE_EMPTY, but table is not empty");
            }
            if (schema == null) {
                schema = table.getSchema();
            }
            LOG.info("Deleting table {}", (Object)BigQueryIO.toTableSpec(ref));
            Bigquery.Tables.Delete delete = this.client.tables().delete(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            delete.execute();
        }
        if (schema == null) {
            throw new IllegalArgumentException("Table schema required for new table.");
        }
        return this.tryCreateTable(ref, schema);
    }

    private boolean isEmpty(TableReference ref) throws IOException {
        Bigquery.Tabledata.List list = this.client.tabledata().list(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
        list.setMaxResults(Long.valueOf(1L));
        TableDataList dataList = (TableDataList)list.execute();
        return dataList.getRows() == null || dataList.getRows().isEmpty();
    }

    @Nullable
    private Table tryCreateTable(TableReference ref, TableSchema schema) throws IOException {
        LOG.info("Trying to create BigQuery table: {}", (Object)BigQueryIO.toTableSpec(ref));
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(RETRY_CREATE_TABLE_DURATION_MILLIS).build();
        Table table = new Table().setTableReference(ref).setSchema(schema);
        return this.tryCreateTable(table, ref.getProjectId(), ref.getDatasetId(), (BackOff)backoff, Sleeper.DEFAULT);
    }

    @Nullable
    @VisibleForTesting
    Table tryCreateTable(Table table, String projectId, String datasetId, BackOff backoff, Sleeper sleeper) throws IOException {
        boolean retry = false;
        while (true) {
            try {
                return (Table)this.client.tables().insert(projectId, datasetId, table).execute();
            }
            catch (IOException e) {
                block8: {
                    ApiErrorExtractor extractor = new ApiErrorExtractor();
                    if (extractor.itemAlreadyExists(e)) {
                        return null;
                    }
                    if (extractor.rateLimited((Throwable)e)) {
                        try {
                            if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                                if (retry) continue;
                                LOG.info("Quota limit reached when creating table {}:{}.{}, retrying up to {} minutes", new Object[]{projectId, datasetId, table.getTableReference().getTableId(), (double)TimeUnit.MILLISECONDS.toSeconds(RETRY_CREATE_TABLE_DURATION_MILLIS) / 60.0});
                                retry = true;
                                continue;
                            }
                            break block8;
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }
}

