/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StandardCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TableRowJsonCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.Sink;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableInserter;
import org.apache.beam.sdk.options.BigQueryOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.AttemptBoundedExponentialBackOff;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.IOChannelFactory;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.apache.beam.sdk.util.Reshuffle;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    private static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    private static final Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    public static final String SET_PROJECT_FROM_OPTIONS_WARNING = "No project specified for BigQuery table \"%1$s.%2$s\". Assuming it is in \"%3$s\". If the table is in a different project please specify it as a part of the BigQuery table definition.";
    private static final String RESOURCE_NOT_FOUND_ERROR = "BigQuery %1$s not found for table \"%2$s\" . Please create the %1$s before pipeline execution. If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final String UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR = "Unable to confirm BigQuery %1$s presence for table \"%2$s\". If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";

    public static TableReference parseTableSpec(String tableSpec) {
        Matcher match = TABLE_SPEC.matcher(tableSpec);
        if (!match.matches()) {
            throw new IllegalArgumentException("Table reference is not in [project_id]:[dataset_id].[table_id] format: " + tableSpec);
        }
        TableReference ref = new TableReference();
        ref.setProjectId(match.group("PROJECT"));
        return ref.setDatasetId(match.group("DATASET")).setTableId(match.group("TABLE"));
    }

    public static String toTableSpec(TableReference ref) {
        StringBuilder sb = new StringBuilder();
        if (ref.getProjectId() != null) {
            sb.append(ref.getProjectId());
            sb.append(":");
        }
        sb.append(ref.getDatasetId()).append('.').append(ref.getTableId());
        return sb.toString();
    }

    private static String getExtractJobId(String jobIdToken) {
        return jobIdToken + "-extract";
    }

    private static String getExtractDestinationUri(String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    private static List<String> getExtractFilePaths(String extractDestinationDir, Job extractJob) throws IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.size() == 0 ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        IOChannelFactory factory = IOChannelUtils.getFactory((String)extractDestinationDir);
        for (long i = 0L; i < filesCount; ++i) {
            String filePath = factory.resolve(extractDestinationDir, String.format("%012d%s", i, ".avro"));
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    private static void verifyDatasetPresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getDataset(table.getProjectId(), table.getDatasetId());
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
        }
    }

    private static void verifyTablePresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getTable(table.getProjectId(), table.getDatasetId(), table.getTableId());
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
        }
    }

    private static Status parseStatus(Job job) {
        if (job == null) {
            return Status.UNKNOWN;
        }
        JobStatus status = job.getStatus();
        if (status.getErrorResult() != null) {
            return Status.FAILED;
        }
        if (status.getErrors() != null && !status.getErrors().isEmpty()) {
            return Status.FAILED;
        }
        return Status.SUCCEEDED;
    }

    @VisibleForTesting
    static String toJsonString(Object item) {
        if (item == null) {
            return null;
        }
        try {
            return JSON_FACTORY.toString(item);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot serialize %s to a JSON string.", item.getClass().getSimpleName()), e);
        }
    }

    @VisibleForTesting
    static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)JSON_FACTORY.fromString(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot deserialize %s from a JSON string: %s.", clazz, json), e);
        }
    }

    private static String randomUUIDString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private BigQueryIO() {
    }

    private static <K, V> List<V> getOrCreateMapListValue(Map<K, List<V>> map, K key) {
        List<V> value = map.get(key);
        if (value == null) {
            value = new ArrayList<V>();
            map.put(key, value);
        }
        return value;
    }

    static enum Status {
        SUCCEEDED,
        FAILED,
        UNKNOWN;

    }

    private static class StreamWithDeDup
    extends PTransform<PCollection<TableRow>, PDone> {
        private final transient TableReference tableReference;
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        private final transient TableSchema tableSchema;
        private final BigQueryServices bqServices;

        StreamWithDeDup(TableReference tableReference, SerializableFunction<BoundedWindow, TableReference> tableRefFunction, TableSchema tableSchema, BigQueryServices bqServices) {
            this.tableReference = tableReference;
            this.tableRefFunction = tableRefFunction;
            this.tableSchema = tableSchema;
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        }

        protected Coder<Void> getDefaultOutputCoder() {
            return VoidCoder.of();
        }

        public PDone apply(PCollection<TableRow> input) {
            PCollection tagged = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new TagWithUniqueIdsAndTable((BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class), this.tableReference, this.tableRefFunction)));
            ((PCollection)tagged.setCoder((Coder)KvCoder.of(ShardedKeyCoder.of(StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of())).apply((PTransform)Reshuffle.of())).apply((PTransform)ParDo.of((DoFn)new StreamingWriteFn(this.tableSchema, this.bqServices)));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    private static class TagWithUniqueIdsAndTable
    extends DoFn<TableRow, KV<ShardedKey<String>, TableRowInfo>>
    implements DoFn.RequiresWindowAccess {
        private final String tableSpec;
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        private transient String randomUUID;
        private transient long sequenceNo = 0L;

        TagWithUniqueIdsAndTable(BigQueryOptions options, TableReference table, SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            Preconditions.checkArgument((boolean)(table == null ^ tableRefFunction == null), (Object)"Exactly one of table or tableRefFunction should be set");
            if (table != null) {
                if (table.getProjectId() == null) {
                    table.setProjectId(((BigQueryOptions)options.as(BigQueryOptions.class)).getProject());
                }
                this.tableSpec = BigQueryIO.toTableSpec(table);
            } else {
                this.tableSpec = null;
            }
            this.tableRefFunction = tableRefFunction;
        }

        public void startBundle(DoFn.Context context) {
            this.randomUUID = UUID.randomUUID().toString();
        }

        public void processElement(DoFn.ProcessContext context) throws IOException {
            String uniqueId = this.randomUUID + this.sequenceNo++;
            ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
            String tableSpec = this.tableSpecFromWindow((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class), context.window());
            context.output((Object)KV.of(ShardedKey.of(tableSpec, randomGenerator.nextInt(0, 50)), (Object)new TableRowInfo((TableRow)context.element(), uniqueId)));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"tableSpec", (String)this.tableSpec));
            if (this.tableRefFunction != null) {
                builder.add(DisplayData.item((String)"tableFn", this.tableRefFunction.getClass()).withLabel("Table Reference Function"));
            }
        }

        private String tableSpecFromWindow(BigQueryOptions options, BoundedWindow window) {
            if (this.tableSpec != null) {
                return this.tableSpec;
            }
            TableReference table = (TableReference)this.tableRefFunction.apply((Object)window);
            if (table.getProjectId() == null) {
                table.setProjectId(options.getProject());
            }
            return BigQueryIO.toTableSpec(table);
        }
    }

    private static class TableRowInfo {
        final TableRow tableRow;
        final String uniqueId;

        TableRowInfo(TableRow tableRow, String uniqueId) {
            this.tableRow = tableRow;
            this.uniqueId = uniqueId;
        }
    }

    private static class TableRowInfoCoder
    extends AtomicCoder<TableRowInfo> {
        private static final TableRowInfoCoder INSTANCE = new TableRowInfoCoder();
        TableRowJsonCoder tableRowCoder = TableRowJsonCoder.of();
        StringUtf8Coder idCoder = StringUtf8Coder.of();

        private TableRowInfoCoder() {
        }

        @JsonCreator
        public static TableRowInfoCoder of() {
            return INSTANCE;
        }

        public void encode(TableRowInfo value, OutputStream outStream, Coder.Context context) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            this.tableRowCoder.encode(value.tableRow, outStream, context.nested());
            this.idCoder.encode(value.uniqueId, outStream, context.nested());
        }

        public TableRowInfo decode(InputStream inStream, Coder.Context context) throws IOException {
            return new TableRowInfo(this.tableRowCoder.decode(inStream, context.nested()), this.idCoder.decode(inStream, context.nested()));
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException((Coder)this, "TableRows are not deterministic.");
        }
    }

    private static class ShardedKeyCoder<KeyT>
    extends StandardCoder<ShardedKey<KeyT>> {
        Coder<KeyT> keyCoder;
        VarIntCoder shardNumberCoder;

        public static <KeyT> ShardedKeyCoder<KeyT> of(Coder<KeyT> keyCoder) {
            return new ShardedKeyCoder<KeyT>(keyCoder);
        }

        @JsonCreator
        public static <KeyT> ShardedKeyCoder<KeyT> of(@JsonProperty(value="component_encodings") List<Coder<KeyT>> components) {
            Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expecting 1 component, got %s", (Object[])new Object[]{components.size()});
            return ShardedKeyCoder.of(components.get(0));
        }

        protected ShardedKeyCoder(Coder<KeyT> keyCoder) {
            this.keyCoder = keyCoder;
            this.shardNumberCoder = VarIntCoder.of();
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.keyCoder);
        }

        public void encode(ShardedKey<KeyT> key, OutputStream outStream, Coder.Context context) throws IOException {
            this.keyCoder.encode(key.getKey(), outStream, context.nested());
            this.shardNumberCoder.encode(Integer.valueOf(key.getShardNumber()), outStream, context);
        }

        public ShardedKey<KeyT> decode(InputStream inStream, Coder.Context context) throws IOException {
            return new ShardedKey(this.keyCoder.decode(inStream, context.nested()), this.shardNumberCoder.decode(inStream, context));
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.keyCoder.verifyDeterministic();
        }
    }

    private static class ShardedKey<K> {
        private final K key;
        private final int shardNumber;

        public static <K> ShardedKey<K> of(K key, int shardNumber) {
            return new ShardedKey<K>(key, shardNumber);
        }

        private ShardedKey(K key, int shardNumber) {
            this.key = key;
            this.shardNumber = shardNumber;
        }

        public K getKey() {
            return this.key;
        }

        public int getShardNumber() {
            return this.shardNumber;
        }
    }

    @SystemDoFnInternal
    private static class StreamingWriteFn
    extends DoFn<KV<ShardedKey<String>, TableRowInfo>, Void> {
        private final String jsonTableSchema;
        private final BigQueryServices bqServices;
        private transient Map<String, List<TableRow>> tableRows;
        private transient Map<String, List<String>> uniqueIdsForTableRows;
        private static Set<String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());
        private Aggregator<Long, Long> byteCountAggregator = this.createAggregator("ByteCount", (Combine.CombineFn)new Sum.SumLongFn());

        StreamingWriteFn(TableSchema schema, BigQueryServices bqServices) {
            this.jsonTableSchema = BigQueryIO.toJsonString(schema);
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        }

        public void startBundle(DoFn.Context context) {
            this.tableRows = new HashMap<String, List<TableRow>>();
            this.uniqueIdsForTableRows = new HashMap<String, List<String>>();
        }

        public void processElement(DoFn.ProcessContext context) {
            String tableSpec = (String)((ShardedKey)((KV)context.element()).getKey()).getKey();
            List rows = BigQueryIO.getOrCreateMapListValue(this.tableRows, tableSpec);
            List uniqueIds = BigQueryIO.getOrCreateMapListValue(this.uniqueIdsForTableRows, tableSpec);
            rows.add(((TableRowInfo)((KV)context.element()).getValue()).tableRow);
            uniqueIds.add(((TableRowInfo)((KV)context.element()).getValue()).uniqueId);
        }

        public void finishBundle(DoFn.Context context) throws Exception {
            BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
            for (Map.Entry<String, List<TableRow>> entry : this.tableRows.entrySet()) {
                TableReference tableReference = this.getOrCreateTable(options, entry.getKey());
                this.flushRows(tableReference, entry.getValue(), this.uniqueIdsForTableRows.get(entry.getKey()), options);
            }
            this.tableRows.clear();
            this.uniqueIdsForTableRows.clear();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"schema", (String)this.jsonTableSchema).withLabel("Table Schema"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TableReference getOrCreateTable(BigQueryOptions options, String tableSpec) throws IOException {
            TableReference tableReference = BigQueryIO.parseTableSpec(tableSpec);
            if (!createdTables.contains(tableSpec)) {
                Set<String> set = createdTables;
                synchronized (set) {
                    if (!createdTables.contains(tableSpec)) {
                        TableSchema tableSchema = (TableSchema)JSON_FACTORY.fromString(this.jsonTableSchema, TableSchema.class);
                        Bigquery client = Transport.newBigQueryClient((BigQueryOptions)options).build();
                        BigQueryTableInserter inserter = new BigQueryTableInserter(client, (PipelineOptions)options);
                        inserter.getOrCreateTable(tableReference, Write.WriteDisposition.WRITE_APPEND, Write.CreateDisposition.CREATE_IF_NEEDED, tableSchema);
                        createdTables.add(tableSpec);
                    }
                }
            }
            return tableReference;
        }

        private void flushRows(TableReference tableReference, List<TableRow> tableRows, List<String> uniqueIds, BigQueryOptions options) throws InterruptedException {
            if (!tableRows.isEmpty()) {
                try {
                    long totalBytes = this.bqServices.getDatasetService(options).insertAll(tableReference, tableRows, uniqueIds);
                    this.byteCountAggregator.addValue((Object)totalBytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static class BigQuerySink
    extends FileBasedSink<TableRow> {
        private final String jobIdToken;
        @Nullable
        private final String jsonTable;
        @Nullable
        private final String jsonSchema;
        private final Write.WriteDisposition writeDisposition;
        private final Write.CreateDisposition createDisposition;
        private final Coder<TableRow> coder;
        private final BigQueryServices bqServices;

        public BigQuerySink(String jobIdToken, @Nullable TableReference table, @Nullable String jsonSchema, Write.WriteDisposition writeDisposition, Write.CreateDisposition createDisposition, String tempFile, Coder<TableRow> coder, BigQueryServices bqServices) {
            super(tempFile, ".json");
            this.jobIdToken = (String)Preconditions.checkNotNull((Object)jobIdToken, (Object)"jobIdToken");
            if (table == null) {
                this.jsonTable = null;
            } else {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)table.getProjectId()) ? 1 : 0) != 0, (String)"Table %s should have a project specified", (Object[])new Object[]{table});
                this.jsonTable = BigQueryIO.toJsonString(table);
            }
            this.jsonSchema = jsonSchema;
            this.writeDisposition = (Write.WriteDisposition)((Object)Preconditions.checkNotNull((Object)((Object)writeDisposition), (Object)"writeDisposition"));
            this.createDisposition = (Write.CreateDisposition)((Object)Preconditions.checkNotNull((Object)((Object)createDisposition), (Object)"createDisposition"));
            this.coder = (Coder)Preconditions.checkNotNull(coder, (Object)"coder");
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        }

        public FileBasedSink.FileBasedWriteOperation<TableRow> createWriteOperation(PipelineOptions options) {
            return new BigQueryWriteOperation(this);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"schema", (String)this.jsonSchema).withLabel("Table Schema")).addIfNotNull(DisplayData.item((String)"tableSpec", (String)this.jsonTable).withLabel("Table Specification"));
        }

        private static class TableRowWriter
        extends FileBasedSink.FileBasedWriter<TableRow> {
            private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
            private final Coder<TableRow> coder;
            private OutputStream out;

            public TableRowWriter(FileBasedSink.FileBasedWriteOperation<TableRow> writeOperation, Coder<TableRow> coder) {
                super(writeOperation);
                this.mimeType = "text/plain";
                this.coder = coder;
            }

            protected void prepareWrite(WritableByteChannel channel) throws Exception {
                this.out = Channels.newOutputStream(channel);
            }

            public void write(TableRow value) throws Exception {
                this.coder.encode((Object)value, this.out, Coder.Context.OUTER);
                this.out.write(NEWLINE);
            }
        }

        private static class BigQueryWriteOperation
        extends FileBasedSink.FileBasedWriteOperation<TableRow> {
            private static final int MAX_RETRY_LOAD_JOBS = 3;
            private static final int LOAD_JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
            private final BigQuerySink bigQuerySink;

            private BigQueryWriteOperation(BigQuerySink sink) {
                super((FileBasedSink)Preconditions.checkNotNull((Object)((Object)sink), (Object)"sink"));
                this.bigQuerySink = sink;
            }

            public FileBasedSink.FileBasedWriter<TableRow> createWriter(PipelineOptions options) throws Exception {
                return new TableRowWriter(this, (Coder<TableRow>)this.bigQuerySink.coder);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finalize(Iterable<FileBasedSink.FileResult> writerResults, PipelineOptions options) throws IOException, InterruptedException {
                try {
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    ArrayList tempFiles = Lists.newArrayList();
                    for (FileBasedSink.FileResult result : writerResults) {
                        tempFiles.add(result.getFilename());
                    }
                    if (!tempFiles.isEmpty()) {
                        this.load(this.bigQuerySink.bqServices.getJobService(bqOptions), this.bigQuerySink.jobIdToken, BigQueryIO.fromJsonString(this.bigQuerySink.jsonTable, TableReference.class), tempFiles, BigQueryIO.fromJsonString(this.bigQuerySink.jsonSchema, TableSchema.class), this.bigQuerySink.writeDisposition, this.bigQuerySink.createDisposition);
                    }
                }
                finally {
                    this.removeTemporaryFiles(options);
                }
            }

            private void load(BigQueryServices.JobService jobService, String jobIdPrefix, TableReference ref, List<String> gcsUris, @Nullable TableSchema schema, Write.WriteDisposition writeDisposition, Write.CreateDisposition createDisposition) throws InterruptedException, IOException {
                JobConfigurationLoad loadConfig = new JobConfigurationLoad().setSourceUris(gcsUris).setDestinationTable(ref).setSchema(schema).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat("NEWLINE_DELIMITED_JSON");
                boolean retrying = false;
                String projectId = ref.getProjectId();
                block5: for (int i = 0; i < 3; ++i) {
                    String jobId = jobIdPrefix + "-" + i;
                    if (retrying) {
                        LOG.info("Previous load jobs failed, retrying.");
                    }
                    LOG.info("Starting BigQuery load job: {}", (Object)jobId);
                    JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
                    jobService.startLoadJob(jobRef, loadConfig);
                    Status jobStatus = BigQueryIO.parseStatus(jobService.pollJob(jobRef, Integer.MAX_VALUE));
                    switch (jobStatus) {
                        case SUCCEEDED: {
                            return;
                        }
                        case UNKNOWN: {
                            throw new RuntimeException("Failed to poll the load job status.");
                        }
                        case FAILED: {
                            LOG.info("BigQuery load job failed: {}", (Object)jobId);
                            retrying = true;
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected job status: " + (Object)((Object)jobStatus));
                        }
                    }
                }
                throw new RuntimeException("Failed to create the load job, reached max retries: 3");
            }
        }
    }

    public static class Write {
        public static Bound to(String tableSpec) {
            return new Bound().to(tableSpec);
        }

        public static Bound to(TableReference table) {
            return new Bound().to(table);
        }

        public static Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
            return new Bound().to(tableSpecFunction);
        }

        public static Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            return new Bound().toTableReference(tableRefFunction);
        }

        public static Bound withSchema(TableSchema schema) {
            return new Bound().withSchema(schema);
        }

        public static Bound withCreateDisposition(CreateDisposition disposition) {
            return new Bound().withCreateDisposition(disposition);
        }

        public static Bound withWriteDisposition(WriteDisposition disposition) {
            return new Bound().withWriteDisposition(disposition);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        private Write() {
        }

        public static class Bound
        extends PTransform<PCollection<TableRow>, PDone> {
            @Nullable
            final String jsonTableRef;
            @Nullable
            final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
            @Nullable
            final String jsonSchema;
            final CreateDisposition createDisposition;
            final WriteDisposition writeDisposition;
            final boolean validate;
            @Nullable
            private BigQueryServices bigQueryServices;

            @Deprecated
            public Bound() {
                this(null, null, null, null, CreateDisposition.CREATE_IF_NEEDED, WriteDisposition.WRITE_EMPTY, true, null);
            }

            private Bound(String name, @Nullable String jsonTableRef, @Nullable SerializableFunction<BoundedWindow, TableReference> tableRefFunction, @Nullable String jsonSchema, CreateDisposition createDisposition, WriteDisposition writeDisposition, boolean validate, @Nullable BigQueryServices bigQueryServices) {
                super(name);
                this.jsonTableRef = jsonTableRef;
                this.tableRefFunction = tableRefFunction;
                this.jsonSchema = jsonSchema;
                this.createDisposition = (CreateDisposition)((Object)Preconditions.checkNotNull((Object)((Object)createDisposition), (Object)"createDisposition"));
                this.writeDisposition = (WriteDisposition)((Object)Preconditions.checkNotNull((Object)((Object)writeDisposition), (Object)"writeDisposition"));
                this.validate = validate;
                this.bigQueryServices = bigQueryServices;
            }

            public Bound to(String tableSpec) {
                return this.to(BigQueryIO.parseTableSpec(tableSpec));
            }

            public Bound to(TableReference table) {
                return new Bound(this.name, BigQueryIO.toJsonString(table), this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                return this.toTableReference(new TranslateTableSpecFunction(tableSpecFunction));
            }

            public Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
                return new Bound(this.name, this.jsonTableRef, tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withSchema(TableSchema schema) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, BigQueryIO.toJsonString(schema), this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withCreateDisposition(CreateDisposition createDisposition) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withWriteDisposition(WriteDisposition writeDisposition) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, false, this.bigQueryServices);
            }

            @VisibleForTesting
            Bound withTestServices(BigQueryServices testServices) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, testServices);
            }

            private static void verifyTableEmpty(BigQueryServices.DatasetService datasetService, TableReference table) {
                block3: {
                    try {
                        boolean isEmpty = datasetService.isTableEmpty(table.getProjectId(), table.getDatasetId(), table.getTableId());
                        if (!isEmpty) {
                            throw new IllegalArgumentException("BigQuery table is not empty: " + BigQueryIO.toTableSpec(table));
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
                        if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) break block3;
                        throw new RuntimeException("unable to confirm BigQuery table emptiness for table " + BigQueryIO.toTableSpec(table), e);
                    }
                }
            }

            public void validate(PCollection<TableRow> input) {
                BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                Preconditions.checkState((this.jsonTableRef != null || this.tableRefFunction != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
                Preconditions.checkState((this.jsonTableRef == null || this.tableRefFunction == null ? 1 : 0) != 0, (Object)"Cannot set both a table reference and a table function for a BigQueryIO.Write transform");
                Preconditions.checkArgument((this.createDisposition != CreateDisposition.CREATE_IF_NEEDED || this.jsonSchema != null ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
                if (this.jsonTableRef != null && this.validate) {
                    TableReference table = this.getTableWithDefaultProject(options);
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                    BigQueryIO.verifyDatasetPresence(datasetService, table);
                    if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                        BigQueryIO.verifyTablePresence(datasetService, table);
                    }
                    if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                        Bound.verifyTableEmpty(datasetService, table);
                    }
                }
                if (input.isBounded() == PCollection.IsBounded.UNBOUNDED || this.tableRefFunction != null) {
                    Preconditions.checkArgument((this.createDisposition != CreateDisposition.CREATE_NEVER ? 1 : 0) != 0, (Object)"CreateDisposition.CREATE_NEVER is not supported for an unbounded PCollection or when using a tablespec function.");
                    Preconditions.checkArgument((this.writeDisposition != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection or when using a tablespec function.");
                } else {
                    String tempLocation = options.getTempLocation();
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Write needs a GCS temp location to store temp files.");
                    if (this.bigQueryServices == null) {
                        try {
                            GcsPath.fromUri((String)tempLocation);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                        }
                    }
                }
            }

            public PDone apply(PCollection<TableRow> input) {
                String tempFilePrefix;
                BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                BigQueryServices bqServices = this.getBigQueryServices();
                if (options.isStreaming() || this.tableRefFunction != null) {
                    return (PDone)input.apply((PTransform)new StreamWithDeDup(this.getTable(), this.tableRefFunction, this.getSchema(), bqServices));
                }
                TableReference table = BigQueryIO.fromJsonString(this.jsonTableRef, TableReference.class);
                if (Strings.isNullOrEmpty((String)table.getProjectId())) {
                    table.setProjectId(options.getProject());
                }
                String jobIdToken = BigQueryIO.randomUUIDString();
                String tempLocation = options.getTempLocation();
                try {
                    IOChannelFactory factory = IOChannelUtils.getFactory((String)tempLocation);
                    tempFilePrefix = factory.resolve(factory.resolve(tempLocation, "BigQuerySinkTemp"), jobIdToken);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to resolve BigQuery temp location in %s", tempLocation), e);
                }
                return (PDone)input.apply("Write", (PTransform)org.apache.beam.sdk.io.Write.to((Sink)new BigQuerySink(jobIdToken, table, this.jsonSchema, this.getWriteDisposition(), this.getCreateDisposition(), tempFilePrefix, (Coder<TableRow>)input.getCoder(), bqServices)));
            }

            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"table", (String)this.jsonTableRef).withLabel("Table Reference")).addIfNotNull(DisplayData.item((String)"schema", (String)this.jsonSchema).withLabel("Table Schema"));
                if (this.tableRefFunction != null) {
                    builder.add(DisplayData.item((String)"tableFn", this.tableRefFunction.getClass()).withLabel("Table Reference Function"));
                }
                builder.add(DisplayData.item((String)"createDisposition", (String)this.createDisposition.toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.writeDisposition.toString()).withLabel("Table WriteDisposition")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.validate).withLabel("Validation Enabled"), (Object)true);
            }

            public CreateDisposition getCreateDisposition() {
                return this.createDisposition;
            }

            public WriteDisposition getWriteDisposition() {
                return this.writeDisposition;
            }

            public TableSchema getSchema() {
                return BigQueryIO.fromJsonString(this.jsonSchema, TableSchema.class);
            }

            @Nullable
            private TableReference getTableWithDefaultProject(BigQueryOptions bqOptions) {
                TableReference table = this.getTable();
                if (table != null && Strings.isNullOrEmpty((String)table.getProjectId())) {
                    table.setProjectId(bqOptions.getProject());
                }
                return table;
            }

            @Nullable
            public TableReference getTable() {
                return BigQueryIO.fromJsonString(this.jsonTableRef, TableReference.class);
            }

            public boolean getValidate() {
                return this.validate;
            }

            private BigQueryServices getBigQueryServices() {
                if (this.bigQueryServices == null) {
                    this.bigQueryServices = new BigQueryServicesImpl();
                }
                return this.bigQueryServices;
            }

            private static class TranslateTableSpecFunction
            implements SerializableFunction<BoundedWindow, TableReference> {
                private SerializableFunction<BoundedWindow, String> tableSpecFunction;

                TranslateTableSpecFunction(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                    this.tableSpecFunction = tableSpecFunction;
                }

                public TableReference apply(BoundedWindow value) {
                    return BigQueryIO.parseTableSpec((String)this.tableSpecFunction.apply((Object)value));
                }
            }
        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }
    }

    @VisibleForTesting
    static class TransformingSource<T, V>
    extends BoundedSource<V> {
        private final BoundedSource<T> boundedSource;
        private final SerializableFunction<T, V> function;
        private final Coder<V> outputCoder;

        TransformingSource(BoundedSource<T> boundedSource, SerializableFunction<T, V> function, Coder<V> outputCoder) {
            this.boundedSource = boundedSource;
            this.function = function;
            this.outputCoder = outputCoder;
        }

        public List<? extends BoundedSource<V>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            return Lists.transform((List)this.boundedSource.splitIntoBundles(desiredBundleSizeBytes, options), (Function)new Function<BoundedSource<T>, BoundedSource<V>>(){

                public BoundedSource<V> apply(BoundedSource<T> input) {
                    return new TransformingSource(input, TransformingSource.this.function, TransformingSource.this.outputCoder);
                }
            });
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            return this.boundedSource.getEstimatedSizeBytes(options);
        }

        public boolean producesSortedKeys(PipelineOptions options) throws Exception {
            return this.boundedSource.producesSortedKeys(options);
        }

        public BoundedSource.BoundedReader<V> createReader(PipelineOptions options) throws IOException {
            return new TransformingReader(this.boundedSource.createReader(options));
        }

        public void validate() {
            this.boundedSource.validate();
        }

        public Coder<V> getDefaultOutputCoder() {
            return this.outputCoder;
        }

        private class TransformingReader
        extends BoundedSource.BoundedReader<V> {
            private final BoundedSource.BoundedReader<T> boundedReader;

            private TransformingReader(BoundedSource.BoundedReader<T> boundedReader) {
                this.boundedReader = boundedReader;
            }

            public synchronized BoundedSource<V> getCurrentSource() {
                return new TransformingSource(this.boundedReader.getCurrentSource(), TransformingSource.this.function, TransformingSource.this.outputCoder);
            }

            public boolean start() throws IOException {
                return this.boundedReader.start();
            }

            public boolean advance() throws IOException {
                return this.boundedReader.advance();
            }

            public V getCurrent() throws NoSuchElementException {
                Object current = this.boundedReader.getCurrent();
                return TransformingSource.this.function.apply(current);
            }

            public void close() throws IOException {
                this.boundedReader.close();
            }

            public synchronized BoundedSource<V> splitAtFraction(double fraction) {
                return new TransformingSource(this.boundedReader.splitAtFraction(fraction), TransformingSource.this.function, TransformingSource.this.outputCoder);
            }

            public Double getFractionConsumed() {
                return this.boundedReader.getFractionConsumed();
            }

            public Instant getCurrentTimestamp() throws NoSuchElementException {
                return this.boundedReader.getCurrentTimestamp();
            }
        }
    }

    private static abstract class BigQuerySourceBase
    extends BoundedSource<TableRow> {
        private static final int MAX_FILES_VERIFY_ATTEMPTS = 10;
        protected static final int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
        private static final long INITIAL_FILES_VERIFY_BACKOFF_MILLIS = TimeUnit.SECONDS.toMillis(1L);
        protected final String jobIdToken;
        protected final String extractDestinationDir;
        protected final BigQueryServices bqServices;
        protected final String executingProject;

        private BigQuerySourceBase(String jobIdToken, String extractDestinationDir, BigQueryServices bqServices, String executingProject) {
            this.jobIdToken = (String)Preconditions.checkNotNull((Object)jobIdToken, (Object)"jobIdToken");
            this.extractDestinationDir = (String)Preconditions.checkNotNull((Object)extractDestinationDir, (Object)"extractDestinationDir");
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
            this.executingProject = (String)Preconditions.checkNotNull((Object)executingProject, (Object)"executingProject");
        }

        public List<BoundedSource<TableRow>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableToExtract = this.getTableToExtract(bqOptions);
            BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
            String extractJobId = BigQueryIO.getExtractJobId(this.jobIdToken);
            List<String> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService);
            TableSchema tableSchema = this.bqServices.getDatasetService(bqOptions).getTable(tableToExtract.getProjectId(), tableToExtract.getDatasetId(), tableToExtract.getTableId()).getSchema();
            this.cleanupTempResource(bqOptions);
            return this.createSources(tempFiles, tableSchema);
        }

        protected abstract TableReference getTableToExtract(BigQueryOptions var1) throws Exception;

        protected abstract void cleanupTempResource(BigQueryOptions var1) throws Exception;

        public boolean producesSortedKeys(PipelineOptions options) throws Exception {
            return false;
        }

        public void validate() {
        }

        public Coder<TableRow> getDefaultOutputCoder() {
            return TableRowJsonCoder.of();
        }

        private List<String> executeExtract(String jobId, TableReference table, BigQueryServices.JobService jobService) throws InterruptedException, IOException {
            JobReference jobRef = new JobReference().setProjectId(this.executingProject).setJobId(jobId);
            String destinationUri = BigQueryIO.getExtractDestinationUri(this.extractDestinationDir);
            JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setDestinationUris((List)ImmutableList.of((Object)destinationUri));
            LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
            jobService.startExtractJob(jobRef, extract);
            Job extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            if (BigQueryIO.parseStatus(extractJob) != Status.SUCCEEDED) {
                throw new IOException(String.format("Extract job %s failed, status: %s", extractJob.getJobReference().getJobId(), extractJob.getStatus()));
            }
            List tempFiles = BigQueryIO.getExtractFilePaths(this.extractDestinationDir, extractJob);
            return ImmutableList.copyOf((Collection)tempFiles);
        }

        private List<BoundedSource<TableRow>> createSources(List<String> files, TableSchema tableSchema) throws IOException, InterruptedException {
            final String jsonSchema = JSON_FACTORY.toString((Object)tableSchema);
            SerializableFunction<GenericRecord, TableRow> function = new SerializableFunction<GenericRecord, TableRow>(){

                public TableRow apply(GenericRecord input) {
                    return BigQueryAvroUtils.convertGenericRecordToTableRow(input, BigQueryIO.fromJsonString(jsonSchema, TableSchema.class));
                }
            };
            ArrayList avroSources = Lists.newArrayList();
            AttemptBoundedExponentialBackOff backoff = new AttemptBoundedExponentialBackOff(10, INITIAL_FILES_VERIFY_BACKOFF_MILLIS);
            for (String fileName : files) {
                while (BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backoff) && IOChannelUtils.getFactory((String)fileName).getSizeBytes(fileName) == -1L) {
                }
                avroSources.add(new TransformingSource<GenericRecord, TableRow>((BoundedSource<GenericRecord>)AvroSource.from((String)fileName), function, this.getDefaultOutputCoder()));
            }
            return ImmutableList.copyOf((Collection)avroSources);
        }

        protected static class BigQueryReader
        extends BoundedSource.BoundedReader<TableRow> {
            private final BigQuerySourceBase source;
            private final BigQueryServices.BigQueryJsonReader reader;

            private BigQueryReader(BigQuerySourceBase source, BigQueryServices.BigQueryJsonReader reader) {
                this.source = source;
                this.reader = reader;
            }

            public BoundedSource<TableRow> getCurrentSource() {
                return this.source;
            }

            public boolean start() throws IOException {
                return this.reader.start();
            }

            public boolean advance() throws IOException {
                return this.reader.advance();
            }

            public TableRow getCurrent() throws NoSuchElementException {
                return this.reader.getCurrent();
            }

            public void close() throws IOException {
                this.reader.close();
            }
        }
    }

    @VisibleForTesting
    static class BigQueryQuerySource
    extends BigQuerySourceBase {
        private final String query;
        private final String jsonQueryTempTable;
        private final Boolean flattenResults;
        private transient AtomicReference<JobStatistics> dryRunJobStats;

        static BigQueryQuerySource create(String jobIdToken, String query, TableReference queryTempTableRef, Boolean flattenResults, String extractDestinationDir, BigQueryServices bqServices) {
            return new BigQueryQuerySource(jobIdToken, query, queryTempTableRef, flattenResults, extractDestinationDir, bqServices);
        }

        private BigQueryQuerySource(String jobIdToken, String query, TableReference queryTempTableRef, Boolean flattenResults, String extractDestinationDir, BigQueryServices bqServices) {
            super(jobIdToken, extractDestinationDir, bqServices, ((TableReference)Preconditions.checkNotNull((Object)queryTempTableRef, (Object)"queryTempTableRef")).getProjectId());
            this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query");
            this.jsonQueryTempTable = BigQueryIO.toJsonString(queryTempTableRef);
            this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
            this.dryRunJobStats = new AtomicReference();
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            return this.dryRunQueryIfNeeded(bqOptions).getTotalBytesProcessed();
        }

        public BoundedSource.BoundedReader<TableRow> createReader(PipelineOptions options) throws IOException {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            return new BigQuerySourceBase.BigQueryReader(this, this.bqServices.getReaderFromQuery(bqOptions, this.query, this.executingProject, this.flattenResults));
        }

        @Override
        protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException, InterruptedException {
            TableReference dryRunTempTable = (TableReference)this.dryRunQueryIfNeeded(bqOptions).getQuery().getReferencedTables().get(0);
            BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
            String location = tableService.getTable(dryRunTempTable.getProjectId(), dryRunTempTable.getDatasetId(), dryRunTempTable.getTableId()).getLocation();
            TableReference tableToExtract = (TableReference)JSON_FACTORY.fromString(this.jsonQueryTempTable, TableReference.class);
            tableService.createDataset(tableToExtract.getProjectId(), tableToExtract.getDatasetId(), location, "");
            String queryJobId = this.jobIdToken + "-query";
            BigQueryQuerySource.executeQuery(this.executingProject, queryJobId, this.query, tableToExtract, this.flattenResults, this.bqServices.getJobService(bqOptions));
            return tableToExtract;
        }

        @Override
        protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
            TableReference tableToRemove = (TableReference)JSON_FACTORY.fromString(this.jsonQueryTempTable, TableReference.class);
            BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
            tableService.deleteTable(tableToRemove.getProjectId(), tableToRemove.getDatasetId(), tableToRemove.getTableId());
            tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", (String)this.query));
        }

        private synchronized JobStatistics dryRunQueryIfNeeded(BigQueryOptions bqOptions) throws InterruptedException, IOException {
            if (this.dryRunJobStats.get() == null) {
                JobStatistics jobStats = this.bqServices.getJobService(bqOptions).dryRunQuery(this.executingProject, this.query);
                this.dryRunJobStats.compareAndSet(null, jobStats);
            }
            return this.dryRunJobStats.get();
        }

        private static void executeQuery(String executingProject, String jobId, String query, TableReference destinationTable, boolean flattenResults, BigQueryServices.JobService jobService) throws IOException, InterruptedException {
            JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(jobId);
            JobConfigurationQuery queryConfig = new JobConfigurationQuery();
            queryConfig.setQuery(query).setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition("CREATE_IF_NEEDED").setDestinationTable(destinationTable).setFlattenResults(Boolean.valueOf(flattenResults)).setPriority("BATCH").setWriteDisposition("WRITE_EMPTY");
            jobService.startQueryJob(jobRef, queryConfig);
            Job job = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            if (BigQueryIO.parseStatus(job) != Status.SUCCEEDED) {
                throw new IOException("Query job failed: " + jobId);
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.dryRunJobStats = new AtomicReference();
        }
    }

    @VisibleForTesting
    static class BigQueryTableSource
    extends BigQuerySourceBase {
        private final String jsonTable;
        private final AtomicReference<Long> tableSizeBytes;

        static BigQueryTableSource create(String jobIdToken, TableReference table, String extractDestinationDir, BigQueryServices bqServices, String executingProject) {
            return new BigQueryTableSource(jobIdToken, table, extractDestinationDir, bqServices, executingProject);
        }

        private BigQueryTableSource(String jobIdToken, TableReference table, String extractDestinationDir, BigQueryServices bqServices, String executingProject) {
            super(jobIdToken, extractDestinationDir, bqServices, executingProject);
            Preconditions.checkNotNull((Object)table, (Object)"table");
            this.jsonTable = BigQueryIO.toJsonString(table);
            this.tableSizeBytes = new AtomicReference();
        }

        @Override
        protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException {
            return (TableReference)JSON_FACTORY.fromString(this.jsonTable, TableReference.class);
        }

        public BoundedSource.BoundedReader<TableRow> createReader(PipelineOptions options) throws IOException {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableRef = (TableReference)JSON_FACTORY.fromString(this.jsonTable, TableReference.class);
            return new BigQuerySourceBase.BigQueryReader(this, this.bqServices.getReaderFromTable(bqOptions, tableRef));
        }

        public synchronized long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            if (this.tableSizeBytes.get() == null) {
                TableReference table = (TableReference)JSON_FACTORY.fromString(this.jsonTable, TableReference.class);
                Long numBytes = this.bqServices.getDatasetService((BigQueryOptions)options.as(BigQueryOptions.class)).getTable(table.getProjectId(), table.getDatasetId(), table.getTableId()).getNumBytes();
                this.tableSizeBytes.compareAndSet(null, numBytes);
            }
            return this.tableSizeBytes.get();
        }

        @Override
        protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"table", (String)this.jsonTable));
        }
    }

    @VisibleForTesting
    static class PassThroughThenCleanup<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private CleanupOperation cleanupOperation;

        PassThroughThenCleanup(CleanupOperation cleanupOperation) {
            this.cleanupOperation = cleanupOperation;
        }

        public PCollection<T> apply(PCollection<T> input) {
            TupleTag mainOutput = new TupleTag();
            TupleTag cleanupSignal = new TupleTag();
            PCollectionTuple outputs = (PCollectionTuple)input.apply((PTransform)ParDo.of(new IdentityFn()).withOutputTags(mainOutput, TupleTagList.of((TupleTag)cleanupSignal)));
            PCollectionView cleanupSignalView = (PCollectionView)outputs.get(cleanupSignal).setCoder((Coder)VoidCoder.of()).apply((PTransform)View.asSingleton().withDefaultValue(null));
            ((PCollection)input.getPipeline().apply("Create(CleanupOperation)", (PTransform)Create.of((Object[])new CleanupOperation[]{this.cleanupOperation}))).apply("Cleanup", (PTransform)ParDo.of((DoFn)new DoFn<CleanupOperation, Void>(){

                public void processElement(DoFn.ProcessContext c) throws Exception {
                    ((CleanupOperation)c.element()).cleanup(c.getPipelineOptions());
                }
            }).withSideInputs(new PCollectionView[]{cleanupSignalView}));
            return outputs.get(mainOutput);
        }

        static abstract class CleanupOperation
        implements Serializable {
            CleanupOperation() {
            }

            abstract void cleanup(PipelineOptions var1) throws Exception;
        }

        private static class IdentityFn<T>
        extends DoFn<T, T> {
            private IdentityFn() {
            }

            public void processElement(DoFn.ProcessContext c) {
                c.output(c.element());
            }
        }
    }

    public static class Read {
        public static Bound from(String tableSpec) {
            return new Bound().from(tableSpec);
        }

        public static Bound fromQuery(String query) {
            return new Bound().fromQuery(query);
        }

        public static Bound from(TableReference table) {
            return new Bound().from(table);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        private Read() {
        }

        public static class Bound
        extends PTransform<PInput, PCollection<TableRow>> {
            @Nullable
            final String jsonTableRef;
            @Nullable
            final String query;
            final boolean validate;
            @Nullable
            final Boolean flattenResults;
            @Nullable
            BigQueryServices bigQueryServices;
            private static final String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";
            private static final int CLEANUP_JOB_POLL_MAX_RETRIES = 10;

            private Bound() {
                this(null, null, null, true, null, null);
            }

            private Bound(String name, @Nullable String query, @Nullable String jsonTableRef, boolean validate, @Nullable Boolean flattenResults, @Nullable BigQueryServices bigQueryServices) {
                super(name);
                this.jsonTableRef = jsonTableRef;
                this.query = query;
                this.validate = validate;
                this.flattenResults = flattenResults;
                this.bigQueryServices = bigQueryServices;
            }

            public Bound from(String tableSpec) {
                return this.from(BigQueryIO.parseTableSpec(tableSpec));
            }

            public Bound from(TableReference table) {
                return new Bound(this.name, this.query, BigQueryIO.toJsonString(table), this.validate, this.flattenResults, this.bigQueryServices);
            }

            public Bound fromQuery(String query) {
                return new Bound(this.name, query, this.jsonTableRef, this.validate, (Boolean)MoreObjects.firstNonNull((Object)this.flattenResults, (Object)Boolean.TRUE), this.bigQueryServices);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.query, this.jsonTableRef, false, this.flattenResults, this.bigQueryServices);
            }

            public Bound withoutResultFlattening() {
                return new Bound(this.name, this.query, this.jsonTableRef, this.validate, false, this.bigQueryServices);
            }

            @VisibleForTesting
            Bound withTestServices(BigQueryServices testServices) {
                return new Bound(this.name, this.query, this.jsonTableRef, this.validate, this.flattenResults, testServices);
            }

            public void validate(PInput input) {
                BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                TableReference table = this.getTableWithDefaultProject(bqOptions);
                if (table == null && this.query == null) {
                    throw new IllegalStateException("Invalid BigQuery read operation, either table reference or query has to be set");
                }
                if (table != null && this.query != null) {
                    throw new IllegalStateException("Invalid BigQuery read operation. Specifies both a query and a table, only one of these should be provided");
                }
                if (table != null && this.flattenResults != null) {
                    throw new IllegalStateException("Invalid BigQuery read operation. Specifies a table with a result flattening preference, which is not configurable");
                }
                if (this.query != null && this.flattenResults == null) {
                    throw new IllegalStateException("Invalid BigQuery read operation. Specifies a query without a result flattening preference");
                }
                if (this.validate) {
                    BigQueryServices bqServices = this.getBigQueryServices();
                    if (table != null) {
                        BigQueryServices.DatasetService datasetService = bqServices.getDatasetService(bqOptions);
                        BigQueryIO.verifyDatasetPresence(datasetService, table);
                        BigQueryIO.verifyTablePresence(datasetService, table);
                    }
                    if (this.query != null) {
                        BigQueryServices.JobService jobService = bqServices.getJobService(bqOptions);
                        try {
                            jobService.dryRunQuery(bqOptions.getProject(), this.query);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.query), e);
                        }
                    }
                }
            }

            public PCollection<TableRow> apply(PInput input) {
                BigQuerySourceBase source;
                String extractDestinationDir;
                String uuid = BigQueryIO.randomUUIDString();
                final String jobIdToken = "beam_job_" + uuid;
                BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                final BigQueryServices bqServices = this.getBigQueryServices();
                String tempLocation = bqOptions.getTempLocation();
                try {
                    IOChannelFactory factory = IOChannelUtils.getFactory((String)tempLocation);
                    extractDestinationDir = factory.resolve(tempLocation, uuid);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to resolve extract destination directory in %s", tempLocation));
                }
                final String executingProject = bqOptions.getProject();
                if (!Strings.isNullOrEmpty((String)this.query)) {
                    String queryTempDatasetId = "temp_dataset_" + uuid;
                    String queryTempTableId = "temp_table_" + uuid;
                    TableReference queryTempTableRef = new TableReference().setProjectId(executingProject).setDatasetId(queryTempDatasetId).setTableId(queryTempTableId);
                    source = BigQueryQuerySource.create(jobIdToken, this.query, queryTempTableRef, this.flattenResults, extractDestinationDir, bqServices);
                } else {
                    TableReference inputTable = this.getTableWithDefaultProject(bqOptions);
                    source = BigQueryTableSource.create(jobIdToken, inputTable, extractDestinationDir, bqServices, executingProject);
                }
                PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                    @Override
                    void cleanup(PipelineOptions options) throws Exception {
                        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                        JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(BigQueryIO.getExtractJobId(jobIdToken));
                        Job extractJob = bqServices.getJobService(bqOptions).pollJob(jobRef, 10);
                        Collection extractFiles = null;
                        if (extractJob != null) {
                            extractFiles = BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob);
                        } else {
                            IOChannelFactory factory = IOChannelUtils.getFactory((String)extractDestinationDir);
                            Collection dirMatch = factory.match(extractDestinationDir);
                            if (!dirMatch.isEmpty()) {
                                extractFiles = factory.match(factory.resolve(extractDestinationDir, "*"));
                            }
                        }
                        if (extractFiles != null && !extractFiles.isEmpty()) {
                            new GcsUtil.GcsUtilFactory().create(options).remove(extractFiles);
                        }
                    }
                };
                return (PCollection)((PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)source))).setCoder(this.getDefaultOutputCoder()).apply(new PassThroughThenCleanup(cleanupOperation));
            }

            protected Coder<TableRow> getDefaultOutputCoder() {
                return TableRowJsonCoder.of();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                TableReference table = this.getTable();
                if (table != null) {
                    builder.add(DisplayData.item((String)"table", (String)BigQueryIO.toTableSpec(table)).withLabel("Table"));
                }
                builder.addIfNotNull(DisplayData.item((String)"query", (String)this.query).withLabel("Query")).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.flattenResults).withLabel("Flatten Query Results")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.validate).withLabel("Validation Enabled"), (Object)true);
            }

            @Nullable
            private TableReference getTableWithDefaultProject(BigQueryOptions bqOptions) {
                TableReference table = this.getTable();
                if (table != null && Strings.isNullOrEmpty((String)table.getProjectId())) {
                    table.setProjectId(bqOptions.getProject());
                }
                return table;
            }

            @Nullable
            public TableReference getTable() {
                return BigQueryIO.fromJsonString(this.jsonTableRef, TableReference.class);
            }

            public String getQuery() {
                return this.query;
            }

            public boolean getValidate() {
                return this.validate;
            }

            public Boolean getFlattenResults() {
                return this.flattenResults;
            }

            private BigQueryServices getBigQueryServices() {
                if (this.bigQueryServices == null) {
                    this.bigQueryServices = new BigQueryServicesImpl();
                }
                return this.bigQueryServices;
            }
        }
    }
}

