/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_BulkIO;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_DocToBulk;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Document;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Read;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_RetryConfiguration;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ElasticsearchIO {
    private static final List<Integer> VALID_CLUSTER_VERSIONS = Arrays.asList(2, 5, 6, 7);
    private static final List<String> VERSION_TYPES = Arrays.asList("internal", "external", "external_gt", "external_gte");
    private static final String VERSION_CONFLICT_ERROR = "version_conflict_engine_exception";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchIO.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Read read() {
        return new AutoValue_ElasticsearchIO_Read.Builder().setWithMetadata(false).setScrollKeepalive("5m").setBatchSize(100L).build();
    }

    public static DocToBulk docToBulk() {
        return new AutoValue_ElasticsearchIO_DocToBulk.Builder().build();
    }

    public static BulkIO bulkIO() {
        return new AutoValue_ElasticsearchIO_BulkIO.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).setUseStatefulBatches(false).setMaxParallelRequestsPerWindow(1).setThrowWriteErrors(true).build();
    }

    public static Write write() {
        return new Write();
    }

    private ElasticsearchIO() {
    }

    @VisibleForTesting
    static JsonNode parseResponse(HttpEntity responseEntity) throws IOException {
        return (JsonNode)mapper.readValue(responseEntity.getContent(), JsonNode.class);
    }

    static List<Document> createWriteReport(HttpEntity responseEntity, @Nullable Set<String> allowedErrorTypes, boolean throwWriteErrors) throws IOException {
        ArrayList<Document> responses = new ArrayList<Document>();
        int numErrors = 0;
        JsonNode searchResult = ElasticsearchIO.parseResponse(responseEntity);
        StringBuilder errorMessages = new StringBuilder("Error writing to Elasticsearch, some elements could not be inserted:");
        JsonNode items = searchResult.path("items");
        if (items.isMissingNode() || items.size() == 0) {
            errorMessages.append(searchResult);
            LOG.warn("'items' missing from Elasticsearch response: {}", (Object)errorMessages);
        }
        for (JsonNode item : items) {
            Document result = Document.create().withResponseItemJson(item.toString());
            JsonNode error = item.findValue("error");
            if (error != null) {
                String type = error.path("type").asText();
                String reason = error.path("reason").asText();
                String docId = item.findValue("_id").asText();
                JsonNode causedBy = error.path("caused_by");
                String cbReason = causedBy.path("reason").asText();
                String cbType = causedBy.path("type").asText();
                if (allowedErrorTypes == null || !allowedErrorTypes.contains(type) && !allowedErrorTypes.contains(cbType)) {
                    result = result.withHasError(true);
                    ++numErrors;
                    errorMessages.append(String.format("%nDocument id %s: %s (%s)", docId, reason, type));
                    if (!causedBy.isMissingNode()) {
                        errorMessages.append(String.format("%nCaused by: %s (%s)", cbReason, cbType));
                    }
                }
            }
            responses.add(result);
        }
        if (numErrors > 0) {
            LOG.error(errorMessages.toString());
            if (throwWriteErrors) {
                throw new IOException(errorMessages.toString());
            }
        }
        return responses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getBackendVersion(ConnectionConfiguration connectionConfiguration) {
        try (RestClient restClient = connectionConfiguration.createClient();){
            Request request = new Request("GET", "");
            Response response = restClient.performRequest(request);
            JsonNode jsonNode = ElasticsearchIO.parseResponse(response.getEntity());
            int backendVersion = Integer.parseInt(jsonNode.path("version").path("number").asText().substring(0, 1));
            Preconditions.checkArgument((boolean)VALID_CLUSTER_VERSIONS.contains(backendVersion), (String)"The Elasticsearch version to connect to is %s.x. This version of the ElasticsearchIO is only compatible with Elasticsearch v7.x, v6.x, v5.x and v2.x", (int)backendVersion);
            int n = backendVersion;
            return n;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get Elasticsearch version", e);
        }
    }

    @AutoValue
    public static abstract class BulkIO
    extends PTransform<PCollection<Document>, PCollectionTuple> {
        @VisibleForTesting
        static final String RETRY_ATTEMPT_LOG = "Error writing to Elasticsearch. Retry attempt[{}]";
        @VisibleForTesting
        static final String RETRY_FAILED_LOG = "Error writing to ES after %d attempt(s). No more attempts allowed";

        abstract @Nullable ConnectionConfiguration getConnectionConfiguration();

        abstract long getMaxBatchSize();

        abstract long getMaxBatchSizeBytes();

        abstract @Nullable Duration getMaxBufferingDuration();

        abstract boolean getUseStatefulBatches();

        abstract int getMaxParallelRequestsPerWindow();

        abstract @Nullable RetryConfiguration getRetryConfiguration();

        abstract @Nullable Set<String> getAllowedResponseErrors();

        abstract boolean getThrowWriteErrors();

        abstract Builder builder();

        public BulkIO withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public BulkIO withMaxBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (String)"batchSize must be > 0, but was %s", (long)batchSize);
            return this.builder().setMaxBatchSize(batchSize).build();
        }

        public BulkIO withMaxBatchSizeBytes(long batchSizeBytes) {
            Preconditions.checkArgument((batchSizeBytes > 0L ? 1 : 0) != 0, (String)"batchSizeBytes must be > 0, but was %s", (long)batchSizeBytes);
            return this.builder().setMaxBatchSizeBytes(batchSizeBytes).build();
        }

        public BulkIO withRetryConfiguration(RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.builder().setRetryConfiguration(retryConfiguration).build();
        }

        public BulkIO withIgnoreVersionConflicts(boolean ignoreVersionConflicts) {
            Set<String> allowedResponseErrors = this.getAllowedResponseErrors();
            if (allowedResponseErrors == null) {
                allowedResponseErrors = new HashSet<String>();
            }
            if (ignoreVersionConflicts) {
                allowedResponseErrors.add(ElasticsearchIO.VERSION_CONFLICT_ERROR);
            }
            return this.builder().setAllowedResponseErrors(allowedResponseErrors).build();
        }

        public BulkIO withAllowableResponseErrors(@Nullable Set<String> allowableResponseErrorTypes) {
            if (allowableResponseErrorTypes == null) {
                allowableResponseErrorTypes = new HashSet<String>();
            }
            return this.builder().setAllowedResponseErrors(allowableResponseErrorTypes).build();
        }

        public BulkIO withMaxBufferingDuration(Duration maxBufferingDuration) {
            LOG.warn("Use of withMaxBufferingDuration requires withUseStatefulBatches(true). Setting that automatically.");
            return this.builder().setUseStatefulBatches(true).setMaxBufferingDuration(maxBufferingDuration).build();
        }

        public BulkIO withUseStatefulBatches(boolean useStatefulBatches) {
            return this.builder().setUseStatefulBatches(useStatefulBatches).build();
        }

        public BulkIO withMaxParallelRequestsPerWindow(int maxParallelRequestsPerWindow) {
            Preconditions.checkArgument((maxParallelRequestsPerWindow > 0 ? 1 : 0) != 0, (Object)"parameter value must be positive a integer");
            return this.builder().setMaxParallelRequestsPerWindow(maxParallelRequestsPerWindow).build();
        }

        public BulkIO withThrowWriteErrors(boolean throwWriteErrors) {
            return this.builder().setThrowWriteErrors(throwWriteErrors).build();
        }

        public PCollectionTuple expand(PCollection<Document> input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState((connectionConfiguration != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            if (this.getUseStatefulBatches()) {
                return (PCollectionTuple)((PCollection)input.apply((PTransform)StatefulBatching.fromSpec(this))).apply((PTransform)ParDo.of((DoFn)new BulkIOStatefulFn(this)).withOutputTags(Write.SUCCESSFUL_WRITES, TupleTagList.of(Write.FAILED_WRITES)));
            }
            return (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new BulkIOBundleFn(this)).withOutputTags(Write.SUCCESSFUL_WRITES, TupleTagList.of(Write.FAILED_WRITES)));
        }

        @VisibleForTesting
        private static abstract class BulkIOBaseFn<T>
        extends DoFn<T, Document> {
            private static final Duration RETRY_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
            private transient FluentBackoff retryBackoff;
            private BulkIO spec;
            private transient RestClient restClient;
            private Multimap<BoundedWindow, Document> batch;
            long currentBatchSizeBytes;

            protected BulkIOBaseFn(BulkIO bulkSpec) {
                this.spec = bulkSpec;
            }

            @DoFn.Setup
            public void setup() throws IOException {
                ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
                this.restClient = connectionConfiguration.createClient();
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0).withInitialBackoff(RETRY_INITIAL_BACKOFF);
                if (this.spec.getRetryConfiguration() != null) {
                    this.retryBackoff = FluentBackoff.DEFAULT.withInitialBackoff(RETRY_INITIAL_BACKOFF).withMaxRetries(this.spec.getRetryConfiguration().getMaxAttempts() - 1).withMaxCumulativeBackoff(this.spec.getRetryConfiguration().getMaxDuration());
                }
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext context) {
                this.batch = ArrayListMultimap.create();
                this.currentBatchSizeBytes = 0L;
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.FinishBundleContext context) throws IOException, InterruptedException {
                this.flushAndOutputResults(new FinishBundleContextAdapter(context));
            }

            private void flushAndOutputResults(ContextAdapter context) throws IOException, InterruptedException {
                Multimap<BoundedWindow, Document> results = this.flushBatch();
                for (Map.Entry result : results.entries()) {
                    BoundedWindow outputWindow = (BoundedWindow)result.getKey();
                    Document outputResult = (Document)result.getValue();
                    Instant timestamp = outputResult.getTimestamp();
                    if (timestamp == null) {
                        timestamp = outputWindow.maxTimestamp();
                    }
                    if (outputResult.getHasError().booleanValue()) {
                        context.output(Write.FAILED_WRITES, outputResult, timestamp, outputWindow);
                        continue;
                    }
                    context.output(Write.SUCCESSFUL_WRITES, outputResult, timestamp, outputWindow);
                }
            }

            protected void addAndMaybeFlush(Document bulkApiEntity, DoFn.ProcessContext context, BoundedWindow outputWindow) throws IOException, InterruptedException {
                this.batch.put((Object)outputWindow, (Object)bulkApiEntity);
                this.currentBatchSizeBytes += (long)bulkApiEntity.getBulkDirective().getBytes(StandardCharsets.UTF_8).length;
                if ((long)this.batch.size() >= this.spec.getMaxBatchSize() || this.currentBatchSizeBytes >= this.spec.getMaxBatchSizeBytes()) {
                    this.flushAndOutputResults(new ProcessContextAdapter(context));
                }
            }

            private boolean isRetryableClientException(Throwable t) {
                return t.getCause() instanceof ConnectTimeoutException || t.getCause() instanceof SocketTimeoutException || t.getCause() instanceof ConnectionClosedException || t.getCause() instanceof ConnectException;
            }

            /*
             * WARNING - void declaration
             */
            private Multimap<BoundedWindow, Document> flushBatch() throws IOException, InterruptedException {
                void var4_9;
                void var4_7;
                if (this.batch.isEmpty()) {
                    return ArrayListMultimap.create();
                }
                LOG.info("ElasticsearchIO batch size: {}, batch size bytes: {}", (Object)this.batch.size(), (Object)this.currentBatchSizeBytes);
                StringBuilder bulkRequest = new StringBuilder();
                ArrayList<Map.Entry<BoundedWindow, Document>> inputEntries = new ArrayList<Map.Entry<BoundedWindow, Document>>(this.batch.entries());
                this.batch.clear();
                this.currentBatchSizeBytes = 0L;
                for (Map.Entry entry : inputEntries) {
                    bulkRequest.append(((Document)entry.getValue()).getBulkDirective());
                }
                Response response = null;
                Object var4_5 = null;
                String endPoint = this.spec.getConnectionConfiguration().getBulkEndPoint();
                NStringEntity requestBody = new NStringEntity(bulkRequest.toString(), ContentType.APPLICATION_JSON);
                try {
                    Request request = new Request("POST", endPoint);
                    request.addParameters(Collections.emptyMap());
                    request.setEntity((HttpEntity)requestBody);
                    response = this.restClient.performRequest(request);
                    BufferedHttpEntity bufferedHttpEntity = new BufferedHttpEntity(response.getEntity());
                }
                catch (IOException ex) {
                    if (this.spec.getRetryConfiguration() == null || !this.isRetryableClientException(ex)) {
                        throw ex;
                    }
                    LOG.error("Caught ES timeout, retrying", (Throwable)ex);
                }
                if (this.spec.getRetryConfiguration() != null && (response == null || var4_7 == null || this.spec.getRetryConfiguration().getRetryPredicate().test(var4_7))) {
                    if (var4_7 != null && this.spec.getRetryConfiguration().getRetryPredicate().test(var4_7)) {
                        LOG.warn("ES Cluster is responding with HTP 429 - TOO_MANY_REQUESTS.");
                    }
                    HttpEntity httpEntity = this.handleRetry("POST", endPoint, Collections.emptyMap(), (HttpEntity)requestBody);
                }
                List<Document> responses = ElasticsearchIO.createWriteReport((HttpEntity)var4_9, this.spec.getAllowedResponseErrors(), this.spec.getThrowWriteErrors());
                return BulkIOBaseFn.mergeInputsAndResponses(inputEntries, responses);
            }

            private static Multimap<BoundedWindow, Document> mergeInputsAndResponses(List<Map.Entry<BoundedWindow, Document>> inputs, List<Document> responses) {
                Preconditions.checkArgument((inputs.size() == responses.size() ? 1 : 0) != 0, (Object)"inputs and responses must be of same size");
                ArrayListMultimap results = ArrayListMultimap.create();
                for (int i = 0; i < inputs.size(); ++i) {
                    BoundedWindow outputWindow = inputs.get(i).getKey();
                    Document inputDoc = inputs.get(i).getValue();
                    Document outputDoc = responses.get(i);
                    Document merged = inputDoc.withHasError(outputDoc.getHasError()).withResponseItemJson(outputDoc.getResponseItemJson());
                    results.put((Object)outputWindow, (Object)merged);
                }
                return results;
            }

            private HttpEntity handleRetry(String method, String endpoint, Map<String, String> params, HttpEntity requestBody) throws IOException, InterruptedException {
                BufferedHttpEntity responseEntity = null;
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = this.retryBackoff.backoff();
                int attempt = 0;
                while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                    block4: {
                        LOG.warn(BulkIO.RETRY_ATTEMPT_LOG, (Object)(++attempt));
                        try {
                            Request request = new Request(method, endpoint);
                            request.addParameters(params);
                            request.setEntity(requestBody);
                            Response response = this.restClient.performRequest(request);
                            responseEntity = new BufferedHttpEntity(response.getEntity());
                        }
                        catch (IOException ex) {
                            if (!this.isRetryableClientException(ex)) break block4;
                            LOG.error("Caught ES timeout, retrying", (Throwable)ex);
                            continue;
                        }
                    }
                    if (!Objects.requireNonNull(this.spec.getRetryConfiguration()).getRetryPredicate().test(responseEntity)) {
                        return responseEntity;
                    }
                    LOG.warn("ES Cluster is responding with HTP 429 - TOO_MANY_REQUESTS.");
                }
                throw new IOException(String.format(BulkIO.RETRY_FAILED_LOG, attempt));
            }

            @DoFn.Teardown
            public void closeClient() throws IOException {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }

            private static final class FinishBundleContextAdapter<T>
            implements ContextAdapter {
                private final DoFn.FinishBundleContext context;

                private FinishBundleContextAdapter(DoFn.FinishBundleContext context) {
                    this.context = context;
                }

                @Override
                public void output(TupleTag<Document> tag, Document document, Instant timestamp, BoundedWindow window) {
                    this.context.output(tag, (Object)document, timestamp, window);
                }
            }

            private static final class ProcessContextAdapter<T>
            implements ContextAdapter {
                private final DoFn.ProcessContext context;

                private ProcessContextAdapter(DoFn.ProcessContext context) {
                    this.context = context;
                }

                @Override
                public void output(TupleTag<Document> tag, Document document, Instant ignored1, BoundedWindow ignored2) {
                    this.context.output(tag, (Object)document);
                }
            }

            static interface ContextAdapter {
                public void output(TupleTag<Document> var1, Document var2, Instant var3, BoundedWindow var4);
            }
        }

        static class BulkIOStatefulFn
        extends BulkIOBaseFn<KV<Integer, Iterable<Document>>> {
            @VisibleForTesting
            BulkIOStatefulFn(BulkIO bulkSpec) {
                super(bulkSpec);
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, BoundedWindow w) throws Exception {
                for (Document result : (Iterable)((KV)c.element()).getValue()) {
                    this.addAndMaybeFlush(result, c, w);
                }
            }
        }

        static class BulkIOBundleFn
        extends BulkIOBaseFn<Document> {
            @VisibleForTesting
            BulkIOBundleFn(BulkIO bulkSpec) {
                super(bulkSpec);
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context, BoundedWindow w) throws Exception {
                Document summary = (Document)context.element();
                this.addAndMaybeFlush(summary, context, w);
            }
        }

        @VisibleForTesting
        static class StatefulBatching
        extends PTransform<PCollection<Document>, PCollection<KV<Integer, Iterable<Document>>>> {
            final BulkIO spec;

            private StatefulBatching(BulkIO bulkSpec) {
                this.spec = bulkSpec;
            }

            public static StatefulBatching fromSpec(BulkIO spec) {
                return new StatefulBatching(spec);
            }

            public PCollection<KV<Integer, Iterable<Document>>> expand(PCollection<Document> input) {
                GroupIntoBatches groupIntoBatches = GroupIntoBatches.ofSize((long)this.spec.getMaxBatchSize());
                if (this.spec.getMaxBufferingDuration() != null) {
                    groupIntoBatches = groupIntoBatches.withMaxBufferingDuration(this.spec.getMaxBufferingDuration());
                }
                return (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new Reshuffle.AssignShardFn(Integer.valueOf(this.spec.getMaxParallelRequestsPerWindow()))))).apply((PTransform)groupIntoBatches);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setMaxBatchSize(long var1);

            abstract Builder setMaxBatchSizeBytes(long var1);

            abstract Builder setRetryConfiguration(RetryConfiguration var1);

            abstract Builder setAllowedResponseErrors(Set<String> var1);

            abstract Builder setMaxBufferingDuration(Duration var1);

            abstract Builder setUseStatefulBatches(boolean var1);

            abstract Builder setMaxParallelRequestsPerWindow(int var1);

            abstract Builder setThrowWriteErrors(boolean var1);

            abstract BulkIO build();
        }
    }

    public static class Write
    extends PTransform<PCollection<String>, PCollectionTuple> {
        public static final TupleTag<Document> SUCCESSFUL_WRITES = new TupleTag<Document>(){};
        public static final TupleTag<Document> FAILED_WRITES = new TupleTag<Document>(){};
        private DocToBulk docToBulk = new AutoValue_ElasticsearchIO_DocToBulk.Builder().build();
        private BulkIO bulkIO = new AutoValue_ElasticsearchIO_BulkIO.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).setUseStatefulBatches(false).setMaxParallelRequestsPerWindow(1).setThrowWriteErrors(true).build();

        public DocToBulk getDocToBulk() {
            return this.docToBulk;
        }

        public BulkIO getBulkIO() {
            return this.bulkIO;
        }

        public Write withIdFn(FieldValueExtractFn idFn) {
            this.docToBulk = this.docToBulk.withIdFn(idFn);
            return this;
        }

        public Write withIndexFn(FieldValueExtractFn indexFn) {
            this.docToBulk = this.docToBulk.withIndexFn(indexFn);
            return this;
        }

        public Write withRoutingFn(FieldValueExtractFn routingFn) {
            this.docToBulk = this.docToBulk.withRoutingFn(routingFn);
            return this;
        }

        public Write withTypeFn(FieldValueExtractFn typeFn) {
            this.docToBulk = this.docToBulk.withTypeFn(typeFn);
            return this;
        }

        public Write withDocVersionFn(FieldValueExtractFn docVersionFn) {
            this.docToBulk = this.docToBulk.withDocVersionFn(docVersionFn);
            return this;
        }

        public Write withDocVersionType(String docVersionType) {
            this.docToBulk = this.docToBulk.withDocVersionType(docVersionType);
            return this;
        }

        public Write withUsePartialUpdate(boolean usePartialUpdate) {
            this.docToBulk = this.docToBulk.withUsePartialUpdate(usePartialUpdate);
            return this;
        }

        public Write withAppendOnly(boolean appendOnly) {
            this.docToBulk = this.docToBulk.withAppendOnly(appendOnly);
            return this;
        }

        public Write withUpsertScript(String source) {
            this.docToBulk = this.docToBulk.withUpsertScript(source);
            return this;
        }

        public Write withBackendVersion(int backendVersion) {
            this.docToBulk = this.docToBulk.withBackendVersion(backendVersion);
            return this;
        }

        public Write withIsDeleteFn(BooleanFieldValueExtractFn isDeleteFn) {
            this.docToBulk = this.docToBulk.withIsDeleteFn(isDeleteFn);
            return this;
        }

        public Write withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            this.docToBulk = this.docToBulk.withConnectionConfiguration(connectionConfiguration);
            this.bulkIO = this.bulkIO.withConnectionConfiguration(connectionConfiguration);
            return this;
        }

        public Write withMaxBatchSize(long batchSize) {
            this.bulkIO = this.bulkIO.withMaxBatchSize(batchSize);
            return this;
        }

        public Write withMaxBatchSizeBytes(long batchSizeBytes) {
            this.bulkIO = this.bulkIO.withMaxBatchSizeBytes(batchSizeBytes);
            return this;
        }

        public Write withRetryConfiguration(RetryConfiguration retryConfiguration) {
            this.bulkIO = this.bulkIO.withRetryConfiguration(retryConfiguration);
            return this;
        }

        public Write withIgnoreVersionConflicts(boolean ignoreVersionConflicts) {
            this.bulkIO = this.bulkIO.withIgnoreVersionConflicts(ignoreVersionConflicts);
            return this;
        }

        public Write withUseStatefulBatches(boolean useStatefulBatches) {
            this.bulkIO = this.bulkIO.withUseStatefulBatches(useStatefulBatches);
            return this;
        }

        public Write withMaxBufferingDuration(Duration maxBufferingDuration) {
            this.bulkIO = this.bulkIO.withMaxBufferingDuration(maxBufferingDuration);
            return this;
        }

        public Write withMaxParallelRequestsPerWindow(int maxParallelRequestsPerWindow) {
            this.bulkIO = this.bulkIO.withMaxParallelRequestsPerWindow(maxParallelRequestsPerWindow);
            return this;
        }

        public Write withAllowableResponseErrors(@Nullable Set<String> allowableResponseErrors) {
            if (allowableResponseErrors == null) {
                allowableResponseErrors = new HashSet<String>();
            }
            this.bulkIO = this.bulkIO.withAllowableResponseErrors(allowableResponseErrors);
            return this;
        }

        public Write withThrowWriteErrors(boolean throwWriteErrors) {
            this.bulkIO = this.bulkIO.withThrowWriteErrors(throwWriteErrors);
            return this;
        }

        public PCollectionTuple expand(PCollection<String> input) {
            return (PCollectionTuple)((PCollection)input.apply((PTransform)this.docToBulk)).apply((PTransform)this.bulkIO);
        }

        public static interface BooleanFieldValueExtractFn
        extends SerializableFunction<JsonNode, Boolean> {
        }

        public static interface FieldValueExtractFn
        extends SerializableFunction<JsonNode, String> {
        }
    }

    @DefaultCoder(value=DocumentCoder.class)
    @AutoValue
    public static abstract class Document
    implements Serializable {
        public abstract @Nullable String getInputDoc();

        public abstract @Nullable String getBulkDirective();

        public abstract Boolean getHasError();

        public abstract @Nullable String getResponseItemJson();

        public abstract @Nullable Instant getTimestamp();

        abstract Builder toBuilder();

        public static Document create() {
            return new AutoValue_ElasticsearchIO_Document.Builder().setHasError(false).build();
        }

        public Document withInputDoc(String inputDoc) {
            return this.toBuilder().setInputDoc(inputDoc).build();
        }

        public Document withBulkDirective(String bulkDirective) {
            return this.toBuilder().setBulkDirective(bulkDirective).build();
        }

        public Document withResponseItemJson(String responseItemJson) {
            return this.toBuilder().setResponseItemJson(responseItemJson).build();
        }

        public Document withHasError(boolean hasError) {
            return this.toBuilder().setHasError(hasError).build();
        }

        public Document withTimestamp(Instant timestamp) {
            return this.toBuilder().setTimestamp(timestamp).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setInputDoc(String var1);

            abstract Builder setBulkDirective(String var1);

            abstract Builder setHasError(boolean var1);

            abstract Builder setResponseItemJson(String var1);

            abstract Builder setTimestamp(Instant var1);

            abstract Document build();
        }
    }

    public static class DocumentCoder
    extends AtomicCoder<Document>
    implements Serializable {
        private static final DocumentCoder INSTANCE = new DocumentCoder();

        private DocumentCoder() {
        }

        public static DocumentCoder of() {
            return INSTANCE;
        }

        public void encode(Document value, OutputStream outStream) throws IOException {
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getInputDoc(), outStream);
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getBulkDirective(), outStream);
            BooleanCoder.of().encode(value.getHasError(), outStream);
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getResponseItemJson(), outStream);
            NullableCoder.of((Coder)InstantCoder.of()).encode((Object)value.getTimestamp(), outStream);
        }

        public Document decode(InputStream inStream) throws IOException {
            String inputDoc = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            String bulkDirective = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            boolean hasError = BooleanCoder.of().decode(inStream);
            String responseItemJson = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            Instant timestamp = (Instant)NullableCoder.of((Coder)InstantCoder.of()).decode(inStream);
            return Document.create().withInputDoc(inputDoc).withBulkDirective(bulkDirective).withHasError(hasError).withResponseItemJson(responseItemJson).withTimestamp(timestamp);
        }
    }

    @AutoValue
    public static abstract class DocToBulk
    extends PTransform<PCollection<String>, PCollection<Document>> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private static final int DEFAULT_RETRY_ON_CONFLICT = 5;

        abstract @Nullable ConnectionConfiguration getConnectionConfiguration();

        abstract @Nullable Write.FieldValueExtractFn getIdFn();

        abstract @Nullable Write.FieldValueExtractFn getIndexFn();

        abstract @Nullable Write.FieldValueExtractFn getRoutingFn();

        abstract @Nullable Write.FieldValueExtractFn getTypeFn();

        abstract @Nullable Write.FieldValueExtractFn getDocVersionFn();

        abstract @Nullable String getDocVersionType();

        abstract @Nullable String getUpsertScript();

        abstract @Nullable Boolean getUsePartialUpdate();

        abstract @Nullable Boolean getAppendOnly();

        abstract @Nullable Write.BooleanFieldValueExtractFn getIsDeleteFn();

        abstract @Nullable Integer getBackendVersion();

        abstract Builder builder();

        public DocToBulk withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public DocToBulk withIdFn(Write.FieldValueExtractFn idFn) {
            Preconditions.checkArgument((idFn != null ? 1 : 0) != 0, (Object)"idFn must not be null");
            return this.builder().setIdFn(idFn).build();
        }

        public DocToBulk withIndexFn(Write.FieldValueExtractFn indexFn) {
            Preconditions.checkArgument((indexFn != null ? 1 : 0) != 0, (Object)"indexFn must not be null");
            return this.builder().setIndexFn(indexFn).build();
        }

        public DocToBulk withRoutingFn(Write.FieldValueExtractFn routingFn) {
            Preconditions.checkArgument((routingFn != null ? 1 : 0) != 0, (Object)"routingFn must not be null");
            return this.builder().setRoutingFn(routingFn).build();
        }

        public DocToBulk withTypeFn(Write.FieldValueExtractFn typeFn) {
            Preconditions.checkArgument((typeFn != null ? 1 : 0) != 0, (Object)"typeFn must not be null");
            return this.builder().setTypeFn(typeFn).build();
        }

        public DocToBulk withUsePartialUpdate(boolean usePartialUpdate) {
            return this.builder().setUsePartialUpdate(usePartialUpdate).build();
        }

        public DocToBulk withAppendOnly(boolean appendOnly) {
            return this.builder().setAppendOnly(appendOnly).build();
        }

        public DocToBulk withUpsertScript(String source) {
            if (this.getBackendVersion() == null || this.getBackendVersion() == 2) {
                LOG.warn("Painless scripts are not supported on Elasticsearch clusters before version 5.0");
            }
            return this.builder().setUsePartialUpdate(false).setUpsertScript(source).build();
        }

        public DocToBulk withDocVersionFn(Write.FieldValueExtractFn docVersionFn) {
            Preconditions.checkArgument((docVersionFn != null ? 1 : 0) != 0, (Object)"docVersionFn must not be null");
            return this.builder().setDocVersionFn(docVersionFn).build();
        }

        public DocToBulk withIsDeleteFn(Write.BooleanFieldValueExtractFn isDeleteFn) {
            Preconditions.checkArgument((isDeleteFn != null ? 1 : 0) != 0, (Object)"deleteFn is required");
            return this.builder().setIsDeleteFn(isDeleteFn).build();
        }

        public DocToBulk withDocVersionType(String docVersionType) {
            Preconditions.checkArgument((boolean)VERSION_TYPES.contains(docVersionType), (String)"docVersionType must be one of %s", (Object)String.join((CharSequence)", ", VERSION_TYPES));
            return this.builder().setDocVersionType(docVersionType).build();
        }

        public DocToBulk withBackendVersion(int backendVersion) {
            Preconditions.checkArgument((boolean)VALID_CLUSTER_VERSIONS.contains(backendVersion), (String)"Backend version may only be one of %s", (Object)String.join((CharSequence)", ", VERSION_TYPES));
            return this.builder().setBackendVersion(backendVersion).build();
        }

        public PCollection<Document> expand(PCollection<String> docs) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Integer backendVersion = this.getBackendVersion();
            Write.FieldValueExtractFn idFn = this.getIdFn();
            Write.BooleanFieldValueExtractFn isDeleteFn = this.getIsDeleteFn();
            Preconditions.checkState((backendVersion != null || connectionConfiguration != null ? 1 : 0) != 0, (Object)"withBackendVersion() or withConnectionConfiguration() is required");
            Preconditions.checkArgument((isDeleteFn == null || idFn != null ? 1 : 0) != 0, (Object)"Id needs to be specified by withIdFn for delete operation");
            return (PCollection)docs.apply((PTransform)ParDo.of((DoFn)new DocToBulkFn(this)));
        }

        @VisibleForTesting
        static String createBulkApiEntity(DocToBulk spec, String document, int backendVersion) throws IOException {
            String documentMetadata = "{}";
            boolean isDelete = false;
            if (spec.getIndexFn() != null || spec.getTypeFn() != null || spec.getIdFn() != null || spec.getRoutingFn() != null) {
                JsonNode parsedDocument = OBJECT_MAPPER.readTree(document);
                documentMetadata = DocToBulk.getDocumentMetadata(spec, parsedDocument, backendVersion);
                if (spec.getIsDeleteFn() != null) {
                    isDelete = (Boolean)spec.getIsDeleteFn().apply(parsedDocument);
                }
            }
            boolean isAppendOnly = Boolean.TRUE.equals(spec.getAppendOnly());
            if (isDelete) {
                Preconditions.checkState((!isAppendOnly ? 1 : 0) != 0, (Object)"No deletions allowed for append-only indices");
                return String.format("{ \"delete\" : %s }%n", documentMetadata);
            }
            if (isAppendOnly) {
                return String.format("{ \"create\" : %s }%n%s%n", documentMetadata, document);
            }
            if (Boolean.TRUE.equals(spec.getUsePartialUpdate())) {
                return String.format("{ \"update\" : %s }%n{ \"doc\" : %s, \"doc_as_upsert\" : true }%n", documentMetadata, document);
            }
            if (spec.getUpsertScript() != null) {
                return String.format("{ \"update\" : %s }%n{ \"script\" : {\"source\": \"%s\", \"params\": %s}, \"upsert\" : %s, \"scripted_upsert\": true}%n", documentMetadata, spec.getUpsertScript(), document, document);
            }
            return String.format("{ \"index\" : %s }%n%s%n", documentMetadata, document);
        }

        private static String lowerCaseOrNull(String input) {
            return input == null ? null : input.toLowerCase();
        }

        private static String getDocumentMetadata(DocToBulk spec, JsonNode parsedDocument, int backendVersion) throws IOException {
            DocumentMetadata metadata = new DocumentMetadata(spec.getIndexFn() != null ? DocToBulk.lowerCaseOrNull((String)spec.getIndexFn().apply(parsedDocument)) : null, spec.getTypeFn() != null ? (String)spec.getTypeFn().apply(parsedDocument) : null, spec.getIdFn() != null ? (String)spec.getIdFn().apply(parsedDocument) : null, Boolean.TRUE.equals(spec.getUsePartialUpdate()) || spec.getUpsertScript() != null && !spec.getUpsertScript().isEmpty() ? Integer.valueOf(5) : null, spec.getRoutingFn() != null ? (String)spec.getRoutingFn().apply(parsedDocument) : null, backendVersion, spec.getDocVersionFn() != null ? (String)spec.getDocVersionFn().apply(parsedDocument) : null, spec.getDocVersionType());
            return OBJECT_MAPPER.writeValueAsString((Object)metadata);
        }

        static {
            SimpleModule module = new SimpleModule();
            module.addSerializer(DocumentMetadata.class, (JsonSerializer)new DocumentMetadataSerializer());
            OBJECT_MAPPER.registerModule((Module)module);
        }

        @VisibleForTesting
        static class DocToBulkFn
        extends DoFn<String, Document> {
            private final DocToBulk spec;
            private int backendVersion;

            public DocToBulkFn(DocToBulk spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws IOException {
                this.backendVersion = this.spec.getBackendVersion() != null ? this.spec.getBackendVersion() : ElasticsearchIO.getBackendVersion(this.spec.getConnectionConfiguration());
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String inputDoc = (String)c.element();
                String bulkDirective = DocToBulk.createBulkApiEntity(this.spec, inputDoc, this.backendVersion);
                c.output((Object)Document.create().withInputDoc(inputDoc).withBulkDirective(bulkDirective).withTimestamp(c.timestamp()));
            }
        }

        private static class DocumentMetadataSerializer
        extends StdSerializer<DocumentMetadata> {
            private DocumentMetadataSerializer() {
                super(DocumentMetadata.class);
            }

            public void serialize(DocumentMetadata value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeStartObject();
                if (value.index != null) {
                    gen.writeStringField("_index", value.index);
                }
                if (value.type != null) {
                    gen.writeStringField("_type", value.type);
                }
                if (value.id != null) {
                    gen.writeStringField("_id", value.id);
                }
                if (value.routing != null) {
                    gen.writeStringField("routing", value.routing);
                }
                if (value.retryOnConflict != null && value.backendVersion <= 6) {
                    gen.writeNumberField("_retry_on_conflict", value.retryOnConflict.intValue());
                }
                if (value.retryOnConflict != null && value.backendVersion >= 7) {
                    gen.writeNumberField("retry_on_conflict", value.retryOnConflict.intValue());
                }
                if (value.version != null) {
                    gen.writeStringField("version", value.version);
                }
                if (value.versionType != null) {
                    gen.writeStringField("version_type", value.versionType);
                }
                gen.writeEndObject();
            }
        }

        private static class DocumentMetadata
        implements Serializable {
            final String index;
            final String type;
            final String id;
            final Integer retryOnConflict;
            final String routing;
            final Integer backendVersion;
            final String version;
            final String versionType;

            DocumentMetadata(String index, String type, String id, Integer retryOnConflict, String routing, Integer backendVersion, String version, String versionType) {
                this.index = index;
                this.id = id;
                this.type = type;
                this.retryOnConflict = retryOnConflict;
                this.routing = routing;
                this.backendVersion = backendVersion;
                this.version = version;
                this.versionType = versionType;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setIdFn(Write.FieldValueExtractFn var1);

            abstract Builder setIndexFn(Write.FieldValueExtractFn var1);

            abstract Builder setRoutingFn(Write.FieldValueExtractFn var1);

            abstract Builder setTypeFn(Write.FieldValueExtractFn var1);

            abstract Builder setDocVersionFn(Write.FieldValueExtractFn var1);

            abstract Builder setDocVersionType(String var1);

            abstract Builder setIsDeleteFn(Write.BooleanFieldValueExtractFn var1);

            abstract Builder setUsePartialUpdate(Boolean var1);

            abstract Builder setAppendOnly(Boolean var1);

            abstract Builder setUpsertScript(String var1);

            abstract Builder setBackendVersion(Integer var1);

            abstract DocToBulk build();
        }
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        @VisibleForTesting
        static final RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract int getMaxAttempts();

        abstract Duration getMaxDuration();

        abstract RetryPredicate getRetryPredicate();

        abstract Builder builder();

        public static RetryConfiguration create(int maxAttempts, Duration maxDuration) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts must be greater than 0");
            Preconditions.checkArgument((maxDuration != null && maxDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration must be greater than 0");
            return new AutoValue_ElasticsearchIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setMaxDuration(maxDuration).setRetryPredicate(DEFAULT_RETRY_PREDICATE).build();
        }

        @VisibleForTesting
        RetryConfiguration withRetryPredicate(RetryPredicate predicate) {
            Preconditions.checkArgument((predicate != null ? 1 : 0) != 0, (Object)"predicate must be provided");
            return this.builder().setRetryPredicate(predicate).build();
        }

        @VisibleForTesting
        static class DefaultRetryPredicate
        implements RetryPredicate {
            private int errorCode;

            DefaultRetryPredicate(int code) {
                this.errorCode = code;
            }

            DefaultRetryPredicate() {
                this(429);
            }

            private static boolean errorCodePresent(HttpEntity responseEntity, int errorCode) {
                try {
                    JsonNode json = ElasticsearchIO.parseResponse(responseEntity);
                    if (json.path("errors").asBoolean()) {
                        for (JsonNode item : json.path("items")) {
                            if (item.findValue("status").asInt() != errorCode) continue;
                            return true;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("Could not extract error codes from responseEntity {}", (Object)responseEntity);
                }
                return false;
            }

            @Override
            public boolean test(HttpEntity responseEntity) {
                return DefaultRetryPredicate.errorCodePresent(responseEntity, this.errorCode);
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<HttpEntity>,
        Serializable {
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setMaxAttempts(int var1);

            abstract Builder setMaxDuration(Duration var1);

            abstract Builder setRetryPredicate(RetryPredicate var1);

            abstract RetryConfiguration build();
        }
    }

    private static class BoundedElasticsearchReader
    extends BoundedSource.BoundedReader<String> {
        private final BoundedElasticsearchSource source;
        private RestClient restClient;
        private String current;
        private String scrollId;
        private ListIterator<String> batchIterator;

        private BoundedElasticsearchReader(BoundedElasticsearchSource source) {
            this.source = source;
        }

        public boolean start() throws IOException {
            String query;
            this.restClient = this.source.spec.getConnectionConfiguration().createClient();
            String string = query = this.source.spec.getQuery() != null ? (String)this.source.spec.getQuery().get() : null;
            if (query == null) {
                query = "{\"query\": { \"match_all\": {} }}";
            }
            if (this.source.backendVersion >= 5 && this.source.numSlices != null && this.source.numSlices > 1) {
                String sliceQuery = String.format("\"slice\": {\"id\": %s,\"max\": %s}", this.source.sliceId, this.source.numSlices);
                query = query.replaceFirst("\\{", "{" + sliceQuery + ",");
            }
            String endPoint = String.format("/%s/%s/_search", this.source.spec.getConnectionConfiguration().getIndex(), this.source.spec.getConnectionConfiguration().getType());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scroll", this.source.spec.getScrollKeepalive());
            if (this.source.backendVersion == 2) {
                params.put("size", String.valueOf(this.source.spec.getBatchSize()));
                if (this.source.shardPreference != null) {
                    params.put("preference", "_shards:" + this.source.shardPreference);
                }
            }
            NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
            Request request = new Request("GET", endPoint);
            request.addParameters(params);
            request.setEntity((HttpEntity)queryEntity);
            Response response = this.restClient.performRequest(request);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response.getEntity());
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private void updateScrollId(JsonNode searchResult) {
            this.scrollId = searchResult.path("_scroll_id").asText();
        }

        public boolean advance() throws IOException {
            if (this.batchIterator.hasNext()) {
                this.current = this.batchIterator.next();
                return true;
            }
            String requestBody = String.format("{\"scroll\" : \"%s\",\"scroll_id\" : \"%s\"}", this.source.spec.getScrollKeepalive(), this.scrollId);
            NStringEntity scrollEntity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            Request request = new Request("GET", "/_search/scroll");
            request.addParameters(Collections.emptyMap());
            request.setEntity((HttpEntity)scrollEntity);
            Response response = this.restClient.performRequest(request);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response.getEntity());
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private boolean readNextBatchAndReturnFirstDocument(JsonNode searchResult) {
            JsonNode hits = searchResult.path("hits").path("hits");
            if (hits.size() == 0) {
                this.current = null;
                this.batchIterator = null;
                return false;
            }
            ArrayList<String> batch = new ArrayList<String>();
            boolean withMetadata = this.source.spec.isWithMetadata();
            for (JsonNode hit : hits) {
                if (withMetadata) {
                    batch.add(hit.toString());
                    continue;
                }
                String document = hit.path("_source").toString();
                batch.add(document);
            }
            this.batchIterator = batch.listIterator();
            this.current = this.batchIterator.next();
            return true;
        }

        public String getCurrent() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            String requestBody = String.format("{\"scroll_id\" : [\"%s\"]}", this.scrollId);
            NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            try {
                Request request = new Request("DELETE", "/_search/scroll");
                request.addParameters(Collections.emptyMap());
                request.setEntity((HttpEntity)entity);
                this.restClient.performRequest(request);
            }
            finally {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        public BoundedSource<String> getCurrentSource() {
            return this.source;
        }
    }

    @VisibleForTesting
    public static class BoundedElasticsearchSource
    extends BoundedSource<String> {
        private int backendVersion;
        private final Read spec;
        private final @Nullable String shardPreference;
        private final @Nullable Integer numSlices;
        private final @Nullable Integer sliceId;
        private @Nullable Long estimatedByteSize;

        private BoundedElasticsearchSource(Read spec, @Nullable String shardPreference, @Nullable Integer numSlices, @Nullable Integer sliceId, @Nullable Long estimatedByteSize, int backendVersion) {
            this.backendVersion = backendVersion;
            this.spec = spec;
            this.shardPreference = shardPreference;
            this.numSlices = numSlices;
            this.estimatedByteSize = estimatedByteSize;
            this.sliceId = sliceId;
        }

        @VisibleForTesting
        BoundedElasticsearchSource(Read spec, @Nullable String shardPreference, @Nullable Integer numSlices, @Nullable Integer sliceId) {
            this.spec = spec;
            this.shardPreference = shardPreference;
            this.numSlices = numSlices;
            this.sliceId = sliceId;
        }

        public List<? extends BoundedSource<String>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
            this.backendVersion = ElasticsearchIO.getBackendVersion(connectionConfiguration);
            ArrayList<BoundedElasticsearchSource> sources = new ArrayList<BoundedElasticsearchSource>();
            if (this.backendVersion == 2) {
                JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration, true);
                JsonNode shardsJson = statsJson.path("indices").path(connectionConfiguration.getIndex()).path("shards");
                Iterator shards = shardsJson.fields();
                while (shards.hasNext()) {
                    Map.Entry shardJson = (Map.Entry)shards.next();
                    String shardId = (String)shardJson.getKey();
                    sources.add(new BoundedElasticsearchSource(this.spec, shardId, null, null, null, this.backendVersion));
                }
                Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"No shard found");
            } else if (this.backendVersion >= 5) {
                long indexSize = this.getEstimatedSizeBytes(options);
                float nbBundlesFloat = (float)indexSize / (float)desiredBundleSizeBytes;
                int nbBundles = (int)Math.ceil(nbBundlesFloat);
                if (nbBundles > 1024) {
                    nbBundles = 1024;
                }
                for (int i = 0; i < nbBundles; ++i) {
                    long estimatedByteSizeForBundle = this.getEstimatedSizeBytes(options) / (long)nbBundles;
                    sources.add(new BoundedElasticsearchSource(this.spec, null, nbBundles, i, estimatedByteSizeForBundle, this.backendVersion));
                }
            }
            return sources;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws IOException {
            String query;
            if (this.estimatedByteSize != null) {
                return this.estimatedByteSize;
            }
            ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
            JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration, false);
            JsonNode indexStats = statsJson.path("indices").path(connectionConfiguration.getIndex()).path("primaries");
            long indexSize = indexStats.path("store").path("size_in_bytes").asLong();
            LOG.debug("estimate source byte size: total index size {}", (Object)indexSize);
            String string = query = this.spec.getQuery() != null ? (String)this.spec.getQuery().get() : null;
            if (query == null || query.isEmpty()) {
                this.estimatedByteSize = indexSize;
                return this.estimatedByteSize;
            }
            long totalCount = indexStats.path("docs").path("count").asLong();
            LOG.debug("estimate source byte size: total document count {}", (Object)totalCount);
            if (totalCount == 0L) {
                this.estimatedByteSize = 1L;
                return this.estimatedByteSize;
            }
            String endPoint = String.format("/%s/%s/_count", connectionConfiguration.getIndex(), connectionConfiguration.getType());
            try (RestClient restClient = connectionConfiguration.createClient();){
                long count = this.queryCount(restClient, endPoint, query);
                LOG.debug("estimate source byte size: query document count {}", (Object)count);
                this.estimatedByteSize = count == 0L ? Long.valueOf(1L) : Long.valueOf(indexSize / totalCount * count);
            }
            return this.estimatedByteSize;
        }

        private long queryCount(@Nonnull RestClient restClient, @Nonnull String endPoint, @Nonnull String query) throws IOException {
            Request request = new Request("GET", endPoint);
            request.setEntity((HttpEntity)new NStringEntity(query, ContentType.APPLICATION_JSON));
            JsonNode searchResult = ElasticsearchIO.parseResponse(restClient.performRequest(request).getEntity());
            return searchResult.path("count").asLong();
        }

        @VisibleForTesting
        static long estimateIndexSize(ConnectionConfiguration connectionConfiguration) throws IOException {
            JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration, false);
            JsonNode indexStats = statsJson.path("indices").path(connectionConfiguration.getIndex()).path("primaries");
            JsonNode store = indexStats.path("store");
            return store.path("size_in_bytes").asLong();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"shard", (String)this.shardPreference));
            builder.addIfNotNull(DisplayData.item((String)"numSlices", (Integer)this.numSlices));
            builder.addIfNotNull(DisplayData.item((String)"sliceId", (Integer)this.sliceId));
        }

        public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) {
            return new BoundedElasticsearchReader(this);
        }

        public void validate() {
            this.spec.validate(null);
        }

        public Coder<String> getOutputCoder() {
            return StringUtf8Coder.of();
        }

        private static JsonNode getStats(ConnectionConfiguration connectionConfiguration, boolean shardLevel) throws IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            if (shardLevel) {
                params.put("level", "shards");
            }
            String endpoint = String.format("/%s/_stats", connectionConfiguration.getIndex());
            try (RestClient restClient = connectionConfiguration.createClient();){
                Request request = new Request("GET", endpoint);
                request.addParameters(params);
                JsonNode jsonNode = ElasticsearchIO.parseResponse(restClient.performRequest(request).getEntity());
                return jsonNode;
            }
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        private static final long MAX_BATCH_SIZE = 10000L;

        abstract @Nullable ConnectionConfiguration getConnectionConfiguration();

        abstract @Nullable ValueProvider<String> getQuery();

        abstract boolean isWithMetadata();

        abstract String getScrollKeepalive();

        abstract long getBatchSize();

        abstract Builder builder();

        public Read withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public Read withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query can not be empty");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.builder().setQuery(query).build();
        }

        public Read withMetadata() {
            return this.builder().setWithMetadata(true).build();
        }

        public Read withScrollKeepalive(String scrollKeepalive) {
            Preconditions.checkArgument((scrollKeepalive != null ? 1 : 0) != 0, (Object)"scrollKeepalive can not be null");
            Preconditions.checkArgument((!"0m".equals(scrollKeepalive) ? 1 : 0) != 0, (Object)"scrollKeepalive can not be 0m");
            return this.builder().setScrollKeepalive(scrollKeepalive).build();
        }

        public Read withBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize > 0L && batchSize <= 10000L ? 1 : 0) != 0, (String)"batchSize must be > 0 and <= %s, but was: %s", (long)10000L, (long)batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public PCollection<String> expand(PBegin input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState((connectionConfiguration != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedElasticsearchSource(this, null, null, null)));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"query", this.getQuery()));
            builder.addIfNotNull(DisplayData.item((String)"withMetadata", (Boolean)this.isWithMetadata()));
            builder.addIfNotNull(DisplayData.item((String)"batchSize", (Long)this.getBatchSize()));
            builder.addIfNotNull(DisplayData.item((String)"scrollKeepalive", (String)this.getScrollKeepalive()));
            this.getConnectionConfiguration().populateDisplayData(builder);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setQuery(ValueProvider<String> var1);

            abstract Builder setWithMetadata(boolean var1);

            abstract Builder setScrollKeepalive(String var1);

            abstract Builder setBatchSize(long var1);

            abstract Read build();
        }
    }

    @AutoValue
    public static abstract class ConnectionConfiguration
    implements Serializable {
        public abstract List<String> getAddresses();

        public abstract @Nullable String getUsername();

        public abstract @Nullable String getPassword();

        public abstract @Nullable String getApiKey();

        public abstract @Nullable String getBearerToken();

        public abstract @Nullable String getKeystorePath();

        public abstract @Nullable String getKeystorePassword();

        public abstract String getIndex();

        public abstract String getType();

        public abstract @Nullable Integer getSocketTimeout();

        public abstract @Nullable Integer getConnectTimeout();

        public abstract boolean isTrustSelfSignedCerts();

        abstract Builder builder();

        public static ConnectionConfiguration create(String[] addresses, String index, String type) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index can not be null");
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type can not be null");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType(type).setTrustSelfSignedCerts(false).build();
        }

        public static ConnectionConfiguration create(String[] addresses, String index) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index can not be null");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType("").setTrustSelfSignedCerts(false).build();
        }

        public static ConnectionConfiguration create(String[] addresses) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex("").setType("").setTrustSelfSignedCerts(false).build();
        }

        public String getBulkEndPoint() {
            StringBuilder sb = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)this.getIndex())) {
                sb.append("/").append(this.getIndex());
            }
            if (!Strings.isNullOrEmpty((String)this.getType())) {
                sb.append("/").append(this.getType());
            }
            sb.append("/").append("_bulk");
            return sb.toString();
        }

        public ConnectionConfiguration withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0, (Object)"username can not be empty");
            return this.builder().setUsername(username).build();
        }

        public ConnectionConfiguration withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            Preconditions.checkArgument((!password.isEmpty() ? 1 : 0) != 0, (Object)"password can not be empty");
            return this.builder().setPassword(password).build();
        }

        public ConnectionConfiguration withApiKey(String apiKey) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)apiKey) ? 1 : 0) != 0, (Object)"apiKey can not be null or empty");
            return this.builder().setApiKey(apiKey).build();
        }

        public ConnectionConfiguration withBearerToken(String bearerToken) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bearerToken) ? 1 : 0) != 0, (Object)"bearerToken can not be null or empty");
            return this.builder().setBearerToken(bearerToken).build();
        }

        public ConnectionConfiguration withKeystorePath(String keystorePath) {
            Preconditions.checkArgument((keystorePath != null ? 1 : 0) != 0, (Object)"keystorePath can not be null");
            Preconditions.checkArgument((!keystorePath.isEmpty() ? 1 : 0) != 0, (Object)"keystorePath can not be empty");
            return this.builder().setKeystorePath(keystorePath).build();
        }

        public ConnectionConfiguration withKeystorePassword(String keystorePassword) {
            Preconditions.checkArgument((keystorePassword != null ? 1 : 0) != 0, (Object)"keystorePassword can not be null");
            return this.builder().setKeystorePassword(keystorePassword).build();
        }

        public ConnectionConfiguration withTrustSelfSignedCerts(boolean trustSelfSignedCerts) {
            return this.builder().setTrustSelfSignedCerts(trustSelfSignedCerts).build();
        }

        public ConnectionConfiguration withSocketTimeout(Integer socketTimeout) {
            Preconditions.checkArgument((socketTimeout != null ? 1 : 0) != 0, (Object)"socketTimeout can not be null");
            return this.builder().setSocketTimeout(socketTimeout).build();
        }

        public ConnectionConfiguration withConnectTimeout(Integer connectTimeout) {
            Preconditions.checkArgument((connectTimeout != null ? 1 : 0) != 0, (Object)"connectTimeout can not be null");
            return this.builder().setConnectTimeout(connectTimeout).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"address", (String)this.getAddresses().toString()));
            builder.add(DisplayData.item((String)"index", (String)this.getIndex()));
            builder.add(DisplayData.item((String)"type", (String)this.getType()));
            builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            builder.addIfNotNull(DisplayData.item((String)"keystore.path", (String)this.getKeystorePath()));
            builder.addIfNotNull(DisplayData.item((String)"socketTimeout", (Integer)this.getSocketTimeout()));
            builder.addIfNotNull(DisplayData.item((String)"connectTimeout", (Integer)this.getConnectTimeout()));
            builder.addIfNotNull(DisplayData.item((String)"trustSelfSignedCerts", (Boolean)this.isTrustSelfSignedCerts()));
        }

        @VisibleForTesting
        RestClient createClient() throws IOException {
            HttpHost[] hosts = new HttpHost[this.getAddresses().size()];
            int i = 0;
            for (String address : this.getAddresses()) {
                URL url = new URL(address);
                hosts[i] = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                ++i;
            }
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts);
            if (this.getUsername() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ConnectionConfiguration.lambda$createClient$0((CredentialsProvider)credentialsProvider, arg_0));
            }
            if (this.getApiKey() != null) {
                restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "ApiKey " + this.getApiKey())});
            }
            if (this.getBearerToken() != null) {
                restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Bearer " + this.getBearerToken())});
            }
            if (this.getKeystorePath() != null && !this.getKeystorePath().isEmpty()) {
                try {
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    try (FileInputStream is = new FileInputStream(new File(this.getKeystorePath()));){
                        String keystorePassword = this.getKeystorePassword();
                        keyStore.load(is, keystorePassword == null ? null : keystorePassword.toCharArray());
                    }
                    TrustSelfSignedStrategy trustStrategy = this.isTrustSelfSignedCerts() ? new TrustSelfSignedStrategy() : null;
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)trustStrategy).build();
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext);
                    restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(sslContext).setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
                }
                catch (Exception e) {
                    throw new IOException("Can't load the client certificate from the keystore", e);
                }
            }
            restClientBuilder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    if (this.getConnectTimeout() != null) {
                        requestConfigBuilder.setConnectTimeout(this.getConnectTimeout().intValue());
                    }
                    if (this.getSocketTimeout() != null) {
                        requestConfigBuilder.setSocketTimeout(this.getSocketTimeout().intValue());
                    }
                    return requestConfigBuilder;
                }
            });
            return restClientBuilder.build();
        }

        private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
            return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setAddresses(List<String> var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setApiKey(String var1);

            abstract Builder setBearerToken(String var1);

            abstract Builder setKeystorePath(String var1);

            abstract Builder setKeystorePassword(String var1);

            abstract Builder setIndex(String var1);

            abstract Builder setType(String var1);

            abstract Builder setSocketTimeout(Integer var1);

            abstract Builder setConnectTimeout(Integer var1);

            abstract Builder setTrustSelfSignedCerts(boolean var1);

            abstract ConnectionConfiguration build();
        }
    }
}

