/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;

final class AutoValue_ElasticsearchIO_ConnectionConfiguration
extends ElasticsearchIO.ConnectionConfiguration {
    private final List<String> addresses;
    private final String username;
    private final String password;
    private final String keystorePath;
    private final String keystorePassword;
    private final String index;
    private final String type;
    private final Integer socketAndRetryTimeout;
    private final Integer connectTimeout;

    private AutoValue_ElasticsearchIO_ConnectionConfiguration(List<String> addresses, @Nullable String username, @Nullable String password, @Nullable String keystorePath, @Nullable String keystorePassword, String index, String type, @Nullable Integer socketAndRetryTimeout, @Nullable Integer connectTimeout) {
        this.addresses = addresses;
        this.username = username;
        this.password = password;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.index = index;
        this.type = type;
        this.socketAndRetryTimeout = socketAndRetryTimeout;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    @Nullable
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Integer getSocketAndRetryTimeout() {
        return this.socketAndRetryTimeout;
    }

    @Override
    @Nullable
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public String toString() {
        return "ConnectionConfiguration{addresses=" + this.addresses + ", username=" + this.username + ", password=" + this.password + ", keystorePath=" + this.keystorePath + ", keystorePassword=" + this.keystorePassword + ", index=" + this.index + ", type=" + this.type + ", socketAndRetryTimeout=" + this.socketAndRetryTimeout + ", connectTimeout=" + this.connectTimeout + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.ConnectionConfiguration) {
            ElasticsearchIO.ConnectionConfiguration that = (ElasticsearchIO.ConnectionConfiguration)o;
            return this.addresses.equals(that.getAddresses()) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && (this.keystorePath == null ? that.getKeystorePath() == null : this.keystorePath.equals(that.getKeystorePath())) && (this.keystorePassword == null ? that.getKeystorePassword() == null : this.keystorePassword.equals(that.getKeystorePassword())) && this.index.equals(that.getIndex()) && this.type.equals(that.getType()) && (this.socketAndRetryTimeout == null ? that.getSocketAndRetryTimeout() == null : this.socketAndRetryTimeout.equals(that.getSocketAndRetryTimeout())) && (this.connectTimeout == null ? that.getConnectTimeout() == null : this.connectTimeout.equals(that.getConnectTimeout()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.addresses.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePath == null ? 0 : this.keystorePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePassword == null ? 0 : this.keystorePassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.index.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.socketAndRetryTimeout == null ? 0 : this.socketAndRetryTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.connectTimeout == null ? 0 : this.connectTimeout.hashCode();
    }

    @Override
    ElasticsearchIO.ConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.ConnectionConfiguration.Builder {
        private List<String> addresses;
        private String username;
        private String password;
        private String keystorePath;
        private String keystorePassword;
        private String index;
        private String type;
        private Integer socketAndRetryTimeout;
        private Integer connectTimeout;

        Builder() {
        }

        private Builder(ElasticsearchIO.ConnectionConfiguration source) {
            this.addresses = source.getAddresses();
            this.username = source.getUsername();
            this.password = source.getPassword();
            this.keystorePath = source.getKeystorePath();
            this.keystorePassword = source.getKeystorePassword();
            this.index = source.getIndex();
            this.type = source.getType();
            this.socketAndRetryTimeout = source.getSocketAndRetryTimeout();
            this.connectTimeout = source.getConnectTimeout();
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setAddresses(List<String> addresses) {
            if (addresses == null) {
                throw new NullPointerException("Null addresses");
            }
            this.addresses = addresses;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setIndex(String index) {
            if (index == null) {
                throw new NullPointerException("Null index");
            }
            this.index = index;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setType(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setSocketAndRetryTimeout(Integer socketAndRetryTimeout) {
            this.socketAndRetryTimeout = socketAndRetryTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration build() {
            String missing = "";
            if (this.addresses == null) {
                missing = missing + " addresses";
            }
            if (this.index == null) {
                missing = missing + " index";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration(this.addresses, this.username, this.password, this.keystorePath, this.keystorePassword, this.index, this.type, this.socketAndRetryTimeout, this.connectTimeout);
        }
    }
}

