/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.math.BigInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

final class RingRange {
    private final @UnknownKeyFor @NonNull @Initialized BigInteger start;
    private final @UnknownKeyFor @NonNull @Initialized BigInteger end;

    RingRange(@UnknownKeyFor @NonNull @Initialized BigInteger start, @UnknownKeyFor @NonNull @Initialized BigInteger end) {
        this.start = start;
        this.end = end;
    }

    @UnknownKeyFor @NonNull @Initialized BigInteger getStart() {
        return this.start;
    }

    @UnknownKeyFor @NonNull @Initialized BigInteger getEnd() {
        return this.end;
    }

    @UnknownKeyFor @NonNull @Initialized BigInteger span(@UnknownKeyFor @NonNull @Initialized BigInteger ringSize) {
        return this.start.compareTo(this.end) >= 0 ? this.end.subtract(this.start).add(ringSize) : this.end.subtract(this.start);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isWrapping() {
        return this.start.compareTo(this.end) >= 0;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("(%s,%s]", this.start.toString(), this.end.toString());
    }
}

