/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.NoSuchElementException;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;

public class PrefetchableIterables {
    private static final PrefetchableIterable<Object> EMPTY_ITERABLE = PrefetchableIterators::emptyIterator;

    public static <T> PrefetchableIterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> PrefetchableIterable<T> fromArray(final T ... values) {
        if (values.length == 0) {
            return PrefetchableIterables.emptyIterable();
        }
        return new PrefetchableIterable<T>(){

            @Override
            public PrefetchableIterator<T> iterator() {
                return PrefetchableIterators.fromArray(values);
            }
        };
    }

    private static <T> PrefetchableIterable<T> maybePrefetchable(final Iterable<T> iterable) {
        if (iterable instanceof PrefetchableIterable) {
            return (PrefetchableIterable)iterable;
        }
        return new PrefetchableIterable<T>(){

            @Override
            public PrefetchableIterator<T> iterator() {
                return PrefetchableIterators.maybePrefetchable(iterable.iterator());
            }
        };
    }

    public static <T> PrefetchableIterable<T> concat(final Iterable<T> ... iterables) {
        for (int i = 0; i < iterables.length; ++i) {
            if (iterables[i] != null) continue;
            throw new IllegalArgumentException("Iterable at position " + i + " was null.");
        }
        if (iterables.length == 0) {
            return PrefetchableIterables.emptyIterable();
        }
        if (iterables.length == 1) {
            return PrefetchableIterables.maybePrefetchable(iterables[0]);
        }
        return new PrefetchableIterable<T>(){

            @Override
            public PrefetchableIterator<T> iterator() {
                return PrefetchableIterators.concatIterators(FluentIterable.from((Object[])iterables).transform(Iterable::iterator).iterator());
            }
        };
    }

    public static <T> PrefetchableIterable<T> limit(Iterable<T> iterable, final int limit) {
        final PrefetchableIterable<T> prefetchableIterable = PrefetchableIterables.maybePrefetchable(iterable);
        return new PrefetchableIterable<T>(){

            @Override
            public PrefetchableIterator<T> iterator() {
                return new PrefetchableIterator<T>(){
                    PrefetchableIterator<T> delegate;
                    int currentPosition;
                    {
                        this.delegate = prefetchableIterable.iterator();
                    }

                    @Override
                    public boolean isReady() {
                        if (this.currentPosition < limit) {
                            return this.delegate.isReady();
                        }
                        return true;
                    }

                    @Override
                    public void prefetch() {
                        if (!this.isReady()) {
                            this.delegate.prefetch();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.currentPosition != limit) {
                            return this.delegate.hasNext();
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.currentPosition;
                        return this.delegate.next();
                    }
                };
            }
        };
    }
}

