/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CancellableQueue<T> {
    private final int capacity;
    private final Object[] elements;
    private final Lock lock;
    private final Condition notFull;
    private final Condition notEmpty;
    int addIndex;
    int takeIndex;
    int count;
    @Nullable
    Exception cancellationException;

    public CancellableQueue(int capacity) {
        this.capacity = capacity;
        this.elements = new Object[capacity];
        this.lock = new ReentrantLock();
        this.notFull = this.lock.newCondition();
        this.notEmpty = this.lock.newCondition();
    }

    public void put(T t) throws Exception, InterruptedException {
        try {
            this.lock.lockInterruptibly();
            while (this.count >= this.capacity && this.cancellationException == null) {
                this.notFull.await();
            }
            if (this.cancellationException != null) {
                throw this.cancellationException;
            }
            this.elements[this.addIndex] = t;
            this.addIndex = (this.addIndex + 1) % this.elements.length;
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws Exception, InterruptedException {
        Object rval;
        try {
            this.lock.lockInterruptibly();
            while (this.count == 0 && this.cancellationException == null) {
                this.notEmpty.await();
            }
            if (this.cancellationException != null) {
                throw this.cancellationException;
            }
            rval = this.elements[this.takeIndex];
            this.takeIndex = (this.takeIndex + 1) % this.elements.length;
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
        return (T)rval;
    }

    public void cancel(Exception exception) {
        try {
            this.lock.lock();
            this.cancellationException = exception;
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        try {
            this.lock.lock();
            this.cancellationException = null;
            this.addIndex = 0;
            this.takeIndex = 0;
            this.count = 0;
        }
        finally {
            this.lock.unlock();
        }
    }
}

