/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.ImplementableFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.ScalarFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;
import org.apache.beam.sdk.extensions.sql.impl.UdfImplReflectiveFunctionBase;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;

public class UdfImpl
extends UdfImplReflectiveFunctionBase
implements ScalarFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private UdfImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static ImmutableMultimap<String, ScalarFunction> createAll(Class<?> clazz) {
        ImmutableMultimap.Builder<String, ScalarFunction> builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isStatic(method.getModifiers()) && !UdfImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            ScalarFunction function = UdfImpl.create(method);
            builder.put(method.getName(), function);
        }
        return builder.build();
    }

    public static ScalarFunction create(Class<?> clazz, String methodName) {
        Method method = UdfImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return UdfImpl.create(method);
    }

    public static ScalarFunction create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !UdfImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        if (method.getExceptionTypes().length != 0) {
            throw new RuntimeException(method.getName() + " must not throw checked exception");
        }
        CallImplementor implementor = UdfImpl.createImplementor(method);
        return new UdfImpl(method, implementor);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return CalciteUtils.sqlTypeWithAutoCast(typeFactory, this.method.getReturnType());
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        NullPolicy nullPolicy = UdfImpl.getNullPolicy(method);
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method), nullPolicy, false);
    }

    private static NullPolicy getNullPolicy(Method m) {
        if (m.getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        return NullPolicy.NONE;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory, SqlOperatorBinding opBinding) {
        RelDataType returnType = this.getReturnType(typeFactory);
        switch (UdfImpl.getNullPolicy(this.method)) {
            case STRICT: {
                for (RelDataType type : opBinding.collectOperandTypes()) {
                    if (!type.isNullable()) continue;
                    return typeFactory.createTypeWithNullability(returnType, true);
                }
                break;
            }
            case SEMI_STRICT: {
                return typeFactory.createTypeWithNullability(returnType, true);
            }
        }
        return returnType;
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge()) continue;
            return method;
        }
        return null;
    }
}

