/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexSqlConvertlet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexToSqlNodeConverter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.DateString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.NlsString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimeString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimestampString;

public class RexToSqlNodeConverterImpl
implements RexToSqlNodeConverter {
    private final RexSqlConvertletTable convertletTable;

    public RexToSqlNodeConverterImpl(RexSqlConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    @Override
    public SqlNode convertNode(RexNode node) {
        if (node instanceof RexLiteral) {
            return this.convertLiteral((RexLiteral)node);
        }
        if (node instanceof RexInputRef) {
            return this.convertInputRef((RexInputRef)node);
        }
        if (node instanceof RexCall) {
            return this.convertCall((RexCall)node);
        }
        return null;
    }

    @Override
    public SqlNode convertCall(RexCall call) {
        RexSqlConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(this, call);
        }
        return null;
    }

    @Override
    public SqlNode convertLiteral(RexLiteral literal) {
        if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createExactNumeric(literal.getValue().toString(), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createApproxNumeric(literal.getValue().toString(), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.TIMESTAMP.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createTimestamp(literal.getValueAs(TimestampString.class), 0, SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.DATE.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createDate(literal.getValueAs(DateString.class), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.TIME.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createTime(literal.getValueAs(TimeString.class), 0, SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.CHARACTER.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createCharString(((NlsString)literal.getValue()).getValue(), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.BOOLEAN.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createBoolean((Boolean)literal.getValue(), SqlParserPos.ZERO);
        }
        return null;
    }

    @Override
    public SqlNode convertInputRef(RexInputRef ref) {
        return null;
    }
}

