/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimestampString;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimestampLiteral(TimestampString ts, int precision, boolean hasTimeZone, SqlParserPos pos) {
        super(ts, hasTimeZone, SqlTypeName.TIMESTAMP, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
    }

    @Override
    public SqlTimestampLiteral clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((TimestampString)this.value, this.precision, this.hasTimeZone, pos);
    }

    @Override
    public String toString() {
        return "TIMESTAMP '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        TimestampString ts = this.getTimestamp();
        if (this.precision > 0) {
            ts = ts.round(this.precision);
        }
        return ts.toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

