/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.IExpressionEvaluator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.IScriptEvaluator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Location;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.ClassBodyEvaluator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.JaninoRuntimeException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Java;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Parser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Scanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.Traverser;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    protected boolean[] optionalOverrideMethod;
    protected boolean[] optionalStaticMethod;
    protected Class[] optionalReturnTypes;
    private String[] optionalMethodNames;
    private String[][] optionalParameterNames;
    private Class[][] optionalParameterTypes;
    private Class[][] optionalThrownExceptions;
    private Method[] result;

    public ScriptEvaluator(String script) throws CompileException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType) throws CompileException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType, String[] parameterNames, Class[] parameterTypes) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(String optionalFileName, InputStream is, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(String optionalFileName, Reader reader, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator(Scanner scanner, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, Class optionalExtendedType, Class[] implementedTypes, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class[] implementedTypes, boolean staticMethod, Class returnType, String methodName, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setStaticMethod(staticMethod);
        this.setReturnType(returnType);
        this.setMethodName(methodName);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator() {
    }

    @Override
    public void setOverrideMethod(boolean overrideMethod) {
        this.setOverrideMethod(new boolean[]{overrideMethod});
    }

    @Override
    public void setStaticMethod(boolean staticMethod) {
        this.setStaticMethod(new boolean[]{staticMethod});
    }

    @Override
    public void setReturnType(Class returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    @Override
    public void setMethodName(String methodName) {
        this.setMethodNames(new String[]{methodName});
    }

    @Override
    public void setParameters(String[] parameterNames, Class[] parameterTypes) {
        this.setParameters(new String[][]{parameterNames}, new Class[][]{parameterTypes});
    }

    @Override
    public void setThrownExceptions(Class[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    @Override
    public final void cook(Scanner scanner) throws CompileException, IOException {
        this.cook(new Scanner[]{scanner});
    }

    @Override
    public Object evaluate(Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    @Override
    public Method getMethod() {
        return this.getMethod(0);
    }

    @Override
    public void setOverrideMethod(boolean[] overrideMethod) {
        this.assertNotCooked();
        this.optionalOverrideMethod = (boolean[])overrideMethod.clone();
    }

    @Override
    public void setStaticMethod(boolean[] staticMethod) {
        this.assertNotCooked();
        this.optionalStaticMethod = (boolean[])staticMethod.clone();
    }

    @Override
    public void setReturnTypes(Class[] returnTypes) {
        this.assertNotCooked();
        this.optionalReturnTypes = (Class[])returnTypes.clone();
    }

    @Override
    public void setMethodNames(String[] methodNames) {
        this.assertNotCooked();
        this.optionalMethodNames = (String[])methodNames.clone();
    }

    @Override
    public void setParameters(String[][] parameterNames, Class[][] parameterTypes) {
        this.assertNotCooked();
        this.optionalParameterNames = (String[][])parameterNames.clone();
        this.optionalParameterTypes = (Class[][])parameterTypes.clone();
    }

    @Override
    public void setThrownExceptions(Class[][] thrownExceptions) {
        this.assertNotCooked();
        this.optionalThrownExceptions = (Class[][])thrownExceptions.clone();
    }

    public final void cook(Scanner[] scanners) throws CompileException, IOException {
        if (scanners == null) {
            throw new NullPointerException();
        }
        Parser[] parsers = new Parser[scanners.length];
        for (int i = 0; i < scanners.length; ++i) {
            parsers[i] = new Parser(scanners[i]);
        }
        this.cook(parsers);
    }

    public final void cook(Parser[] parsers) throws CompileException, IOException {
        int i;
        String[] methodNames;
        int count = parsers.length;
        if (this.optionalMethodNames != null && this.optionalMethodNames.length != count) {
            throw new IllegalStateException("methodName count");
        }
        if (this.optionalParameterNames != null && this.optionalParameterNames.length != count) {
            throw new IllegalStateException("parameterNames count");
        }
        if (this.optionalParameterTypes != null && this.optionalParameterTypes.length != count) {
            throw new IllegalStateException("parameterTypes count");
        }
        if (this.optionalOverrideMethod != null && this.optionalOverrideMethod.length != count) {
            throw new IllegalStateException("overrideMethod count");
        }
        if (this.optionalReturnTypes != null && this.optionalReturnTypes.length != count) {
            throw new IllegalStateException("returnTypes count");
        }
        if (this.optionalStaticMethod != null && this.optionalStaticMethod.length != count) {
            throw new IllegalStateException("staticMethod count");
        }
        if (this.optionalThrownExceptions != null && this.optionalThrownExceptions.length != count) {
            throw new IllegalStateException("thrownExceptions count");
        }
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(count == 1 ? parsers[0] : null);
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(parsers[0].location(), compilationUnit);
        if (this.optionalMethodNames == null) {
            methodNames = new String[count];
            for (i = 0; i < count; ++i) {
                methodNames[i] = "eval" + i;
            }
        } else {
            methodNames = this.optionalMethodNames;
        }
        for (i = 0; i < count; ++i) {
            Java.Annotation[] annotationArray;
            Parser parser = parsers[i];
            List<Java.BlockStatement> statements = this.makeStatements(i, parser);
            boolean staticMethod = this.optionalStaticMethod == null || this.optionalStaticMethod[i];
            boolean overrideMethod = this.optionalOverrideMethod != null && this.optionalOverrideMethod[i];
            Class returnType = this.optionalReturnTypes == null ? this.getDefaultReturnType() : this.optionalReturnTypes[i];
            String[] parameterNames = this.optionalParameterNames == null ? new String[]{} : this.optionalParameterNames[i];
            Class[] parameterTypes = this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i];
            Class[] thrownExceptions = this.optionalThrownExceptions == null ? new Class[]{} : this.optionalThrownExceptions[i];
            Location loc = parser.location();
            if (overrideMethod) {
                Java.Annotation[] annotationArray2 = new Java.Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = new Java.MarkerAnnotation(this.classToType(loc, Override.class));
            } else {
                annotationArray = new Java.Annotation[]{};
            }
            cd.addDeclaredMethod(this.makeMethodDeclaration(loc, annotationArray, staticMethod, returnType, methodNames[i], parameterTypes, parameterNames, thrownExceptions, statements));
        }
        Class c = this.compileToClass(compilationUnit);
        this.result = new Method[count];
        if (count <= 10) {
            for (int i2 = 0; i2 < count; ++i2) {
                try {
                    this.result[i2] = c.getDeclaredMethod(methodNames[i2], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i2]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i2] + "\"", ex);
                }
            }
        } else {
            Method[] ma = c.getDeclaredMethods();
            class MethodWrapper {
                private final String name;
                private final Class[] parameterTypes;

                MethodWrapper(String name, Class[] parameterTypes) {
                    this.name = name;
                    this.parameterTypes = parameterTypes;
                }

                public boolean equals(Object o) {
                    if (!(o instanceof MethodWrapper)) {
                        return false;
                    }
                    MethodWrapper that = (MethodWrapper)o;
                    if (!this.name.equals(that.name)) {
                        return false;
                    }
                    int cnt = this.parameterTypes.length;
                    if (cnt != that.parameterTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < cnt; ++i) {
                        if (this.parameterTypes[i].equals(that.parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int hc = this.name.hashCode();
                    for (Class parameterType : this.parameterTypes) {
                        hc ^= parameterType.hashCode();
                    }
                    return hc;
                }
            }
            HashMap<MethodWrapper, Method> dms = new HashMap<MethodWrapper, Method>(2 * count);
            for (Method m : ma) {
                dms.put(new MethodWrapper(m.getName(), m.getParameterTypes()), m);
            }
            for (int i3 = 0; i3 < count; ++i3) {
                Method m = (Method)dms.get(new MethodWrapper(methodNames[i3], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i3]));
                if (m == null) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i3] + "\"");
                }
                this.result[i3] = m;
            }
        }
    }

    @Override
    public final void cook(Reader[] readers) throws CompileException, IOException {
        this.cook(new String[readers.length], readers);
    }

    @Override
    public final void cook(String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        Scanner[] scanners = new Scanner[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            scanners[i] = new Scanner(optionalFileNames == null ? null : optionalFileNames[i], readers[i]);
        }
        this.cook(scanners);
    }

    @Override
    public final void cook(String[] strings) throws CompileException {
        this.cook(null, strings);
    }

    @Override
    public final void cook(String[] optionalFileNames, String[] strings) throws CompileException {
        Reader[] readers = new Reader[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            readers[i] = new StringReader(strings[i]);
        }
        try {
            this.cook(optionalFileNames, readers);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException("SNO: IOException despite StringReader", ex);
        }
    }

    protected Class getDefaultReturnType() {
        return Void.TYPE;
    }

    protected List<Java.BlockStatement> makeStatements(int idx, Parser parser) throws CompileException, IOException {
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        while (!parser.peekEof()) {
            statements.add(parser.parseBlockStatement());
        }
        return statements;
    }

    protected Java.MethodDeclarator makeMethodDeclaration(Location location, Java.Annotation[] annotations, boolean staticMethod, Class returnType, String methodName, Class[] parameterTypes, String[] parameterNames, Class[] thrownExceptions, List<Java.BlockStatement> statements) {
        if (parameterNames.length != parameterTypes.length) {
            throw new JaninoRuntimeException("Lengths of \"parameterNames\" (" + parameterNames.length + ") and \"parameterTypes\" (" + parameterTypes.length + ") do not match");
        }
        Java.FunctionDeclarator.FormalParameters fps = new Java.FunctionDeclarator.FormalParameters(location, new Java.FunctionDeclarator.FormalParameter[parameterNames.length], false);
        for (int i = 0; i < fps.parameters.length; ++i) {
            fps.parameters[i] = new Java.FunctionDeclarator.FormalParameter(location, true, this.classToType(location, parameterTypes[i]), parameterNames[i]);
        }
        return new Java.MethodDeclarator(location, null, new Java.Modifiers(staticMethod ? (short)9 : 1, annotations), this.classToType(location, returnType), methodName, fps, this.classesToTypes(location, thrownExceptions), statements);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(String script, Class interfaceToImplement, String[] parameterNames) throws CompileException {
        ScriptEvaluator se = new ScriptEvaluator();
        return se.createFastEvaluator(script, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedType);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, String[] optionalDefaultImports, String className, Class optionalExtendedClass, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setDefaultImports(optionalDefaultImports);
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedClass);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Override
    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public Object createFastEvaluator(Reader reader, Class interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        return this.createFastEvaluator(new Scanner(null, reader), interfaceToImplement, parameterNames);
    }

    public Object createFastEvaluator(String script, Class interfaceToImplement, String[] parameterNames) throws CompileException {
        try {
            return this.createFastEvaluator((Reader)new StringReader(script), interfaceToImplement, parameterNames);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException("IOException despite StringReader", ex);
        }
    }

    public Object createFastEvaluator(Scanner scanner, Class interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new JaninoRuntimeException("\"" + interfaceToImplement + "\" is not an interface");
        }
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new JaninoRuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        this.setImplementedInterfaces(new Class[]{interfaceToImplement});
        this.setOverrideMethod(true);
        this.setStaticMethod(false);
        if (this instanceof IExpressionEvaluator) {
            ((IExpressionEvaluator)((Object)this)).setExpressionType(methodToImplement.getReturnType());
        } else {
            this.setReturnType(methodToImplement.getReturnType());
        }
        this.setMethodName(methodToImplement.getName());
        this.setParameters(parameterNames, methodToImplement.getParameterTypes());
        this.setThrownExceptions(methodToImplement.getExceptionTypes());
        this.cook(scanner);
        Class<?> c = this.getMethod().getDeclaringClass();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new JaninoRuntimeException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new JaninoRuntimeException(e.toString(), e);
        }
    }

    public static String[] guessParameterNames(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        while (parser.peek("import")) {
            parser.parseImportDeclaration();
        }
        Java.Block block = new Java.Block(scanner.location());
        while (!parser.peekEof()) {
            block.addStatement(parser.parseBlockStatement());
        }
        final HashSet localVariableNames = new HashSet();
        final HashSet parameterNames = new HashSet();
        new Traverser(){

            @Override
            public void traverseLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
                    localVariableNames.add(vd.name);
                }
                super.traverseLocalVariableDeclarationStatement(lvds);
            }

            @Override
            public void traverseAmbiguousName(Java.AmbiguousName an) {
                for (int i = 0; i < an.identifiers.length; ++i) {
                    if (!Character.isUpperCase(an.identifiers[i].charAt(0))) continue;
                    return;
                }
                if (localVariableNames.contains(an.identifiers[0])) {
                    return;
                }
                parameterNames.add(an.identifiers[0]);
            }
        }.traverseBlock(block);
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    @Override
    public Object evaluate(int idx, Object[] arguments) throws InvocationTargetException {
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        try {
            return this.result[idx].invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new JaninoRuntimeException(ex.toString(), ex);
        }
    }

    @Override
    public Method getMethod(int idx) {
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result[idx];
    }
}

