/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Calc;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionExecutor;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutor;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;

public class BeamCalcRel
extends Calc
implements BeamRelNode {
    public BeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    @Override
    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    public int getLimitCountOfSortRel() {
        if (this.input instanceof BeamSortRel) {
            return ((BeamSortRel)this.input).getCount();
        }
        throw new RuntimeException("Could not get the limit count from a non BeamSortRel input.");
    }

    public boolean isInputSortRelAndLimitOnly() {
        return this.input instanceof BeamSortRel && ((BeamSortRel)this.input).isLimitOnly();
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private BeamSqlExpressionExecutor executor;
        private Schema outputSchema;

        public CalcFn(BeamSqlExpressionExecutor executor, Schema outputSchema) {
            this.executor = executor;
            this.outputSchema = outputSchema;
        }

        @DoFn.Setup
        public void setup() {
            this.executor.prepare();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            Row inputRow = (Row)c.element();
            List<Object> rawResultValues = this.executor.execute(inputRow, window, BeamSqlExpressionEnvironments.forRow(inputRow, window));
            if (rawResultValues != null) {
                List castResultValues = IntStream.range(0, this.outputSchema.getFieldCount()).mapToObj(i -> this.castField(rawResultValues, i)).collect(Collectors.toList());
                c.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(castResultValues).build());
            }
        }

        private Object castField(List<Object> resultValues, int i) {
            return BeamTableUtils.autoCastField(this.outputSchema.getField(i), resultValues.get(i));
        }

        @DoFn.Teardown
        public void close() {
            this.executor.close();
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument(pinput.size() == 1, "Wrong number of inputs for %s: %s", (Object)BeamCalcRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            BeamSqlFnExecutor executor = new BeamSqlFnExecutor(BeamCalcRel.this.getProgram());
            Schema schema = CalciteUtils.toSchema(BeamCalcRel.this.rowType);
            PCollection projectStream = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new CalcFn(executor, CalciteUtils.toSchema(BeamCalcRel.this.rowType))))).setRowSchema(schema);
            projectStream.setRowSchema(CalciteUtils.toSchema(BeamCalcRel.this.getRowType()));
            return projectStream;
        }
    }
}

