/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlMathBinaryExpression;

public class BeamSqlRoundExpression
extends BeamSqlMathBinaryExpression {
    private final BeamSqlPrimitive zero = BeamSqlPrimitive.of(SqlTypeName.INTEGER, 0);

    public BeamSqlRoundExpression(List<BeamSqlExpression> operands) {
        super(operands, operands.get(0).getOutputType());
        this.checkForSecondOperand(operands);
    }

    private void checkForSecondOperand(List<BeamSqlExpression> operands) {
        if (this.numberOfOperands() == 1) {
            operands.add(1, this.zero);
        }
    }

    @Override
    public BeamSqlPrimitive<? extends Number> calculate(BeamSqlPrimitive leftOp, BeamSqlPrimitive rightOp) {
        BeamSqlPrimitive<Number> result = null;
        switch (leftOp.getOutputType()) {
            case SMALLINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.SMALLINT, (short)this.roundInt(this.toInt(leftOp.getValue()), this.toInt(rightOp.getValue())));
                break;
            }
            case TINYINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.TINYINT, (byte)this.roundInt(this.toInt(leftOp.getValue()), this.toInt(rightOp.getValue())));
                break;
            }
            case INTEGER: {
                result = BeamSqlPrimitive.of(SqlTypeName.INTEGER, this.roundInt(leftOp.getInteger(), this.toInt(rightOp.getValue())));
                break;
            }
            case BIGINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.BIGINT, this.roundLong(leftOp.getLong(), this.toInt(rightOp.getValue())));
                break;
            }
            case DOUBLE: {
                result = BeamSqlPrimitive.of(SqlTypeName.DOUBLE, this.roundDouble(leftOp.getDouble(), this.toInt(rightOp.getValue())));
                break;
            }
            case FLOAT: {
                result = BeamSqlPrimitive.of(SqlTypeName.FLOAT, Float.valueOf((float)this.roundDouble(leftOp.getFloat(), this.toInt(rightOp.getValue()))));
                break;
            }
            case DECIMAL: {
                result = BeamSqlPrimitive.of(SqlTypeName.DECIMAL, this.roundBigDecimal(this.toBigDecimal(leftOp.getValue()), this.toInt(rightOp.getValue())));
                break;
            }
        }
        return result;
    }

    private int roundInt(int v1, int v2) {
        return SqlFunctions.sround(v1, v2);
    }

    private double roundDouble(double v1, int v2) {
        return SqlFunctions.sround(v1, v2);
    }

    private BigDecimal roundBigDecimal(BigDecimal v1, int v2) {
        return SqlFunctions.sround(v1, v2);
    }

    private long roundLong(long v1, int v2) {
        return SqlFunctions.sround(v1, v2);
    }

    private int toInt(Object value) {
        return SqlFunctions.toInt(value);
    }

    private BigDecimal toBigDecimal(Object value) {
        return SqlFunctions.toBigDecimal(value);
    }
}

