/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlBinaryOperator;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlOperator;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlUnaryOperator;

public class StringOperators {
    public static final BeamSqlOperator CHAR_LENGTH = arg -> BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.charLength(arg.getString()));
    public static final BeamSqlOperator UPPER = arg -> BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.upper(arg.getString()));
    public static final BeamSqlOperator LOWER = arg -> BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.lower(arg.getString()));
    public static final BeamSqlOperator INIT_CAP = arg -> BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.initcap(arg.getString()));
    public static final BeamSqlBinaryOperator CONCAT = new BeamSqlBinaryOperator(){

        @Override
        public SqlTypeName getOutputType() {
            return SqlTypeName.VARCHAR;
        }

        @Override
        public boolean accept(BeamSqlExpression left, BeamSqlExpression right) {
            return SqlTypeName.CHAR_TYPES.contains((Object)left.getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)right.getOutputType());
        }

        @Override
        public BeamSqlPrimitive apply(BeamSqlPrimitive left, BeamSqlPrimitive right) {
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.concat(left.getString(), right.getString()));
        }
    };
    public static final BeamSqlOperator POSITION = new StringOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> operands) {
            if (operands.size() < 2 || operands.size() > 3) {
                return false;
            }
            return SqlTypeName.CHAR_TYPES.contains((Object)operands.get(0).getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(1).getOutputType()) && (operands.size() < 3 || SqlTypeName.INT_TYPES.contains((Object)operands.get(2).getOutputType()));
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> arguments) {
            String targetStr = arguments.get(0).getString();
            String containingStr = arguments.get(1).getString();
            int from = arguments.size() < 3 ? 1 : arguments.get(2).getInteger();
            return BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.position(targetStr, containingStr, from));
        }
    };
    public static final BeamSqlOperator TRIM = new StringOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> subexpressions) {
            return subexpressions.size() == 1 && SqlTypeName.CHAR_TYPES.contains((Object)subexpressions.get(0).getOutputType()) || subexpressions.size() == 3 && SqlTypeName.SYMBOL.equals((Object)subexpressions.get(0).getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)subexpressions.get(1).getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)subexpressions.get(2).getOutputType());
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> operands) {
            String fromStr;
            String removeChars;
            SqlTrimFunction.Flag type;
            if (operands.size() == 1) {
                type = SqlTrimFunction.Flag.BOTH;
                removeChars = " ";
                fromStr = operands.get(0).getString();
            } else {
                type = (SqlTrimFunction.Flag)((Object)operands.get(0).getValue());
                removeChars = operands.get(1).getString();
                fromStr = operands.get(2).getString();
            }
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, StringOperators.trim(type == SqlTrimFunction.Flag.BOTH || type == SqlTrimFunction.Flag.LEADING, type == SqlTrimFunction.Flag.BOTH || type == SqlTrimFunction.Flag.TRAILING, removeChars, fromStr));
        }
    };
    public static final BeamSqlOperator OVERLAY = new StringOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> operands) {
            return operands.size() == 3 && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(0).getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(1).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(2).getOutputType()) || operands.size() == 4 && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(0).getOutputType()) && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(1).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(2).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(3).getOutputType());
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> operands) {
            String str = operands.get(0).getString();
            String replaceStr = operands.get(1).getString();
            int idx = operands.get(2).getInteger();
            int length = operands.size() == 4 ? operands.get(3).getInteger() : replaceStr.length();
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.overlay(str, replaceStr, idx, length));
        }
    };
    public static final BeamSqlOperator SUBSTRING = new StringOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> operands) {
            return operands.size() == 2 && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(0).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(1).getOutputType()) || operands.size() == 3 && SqlTypeName.CHAR_TYPES.contains((Object)operands.get(0).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(1).getOutputType()) && SqlTypeName.INT_TYPES.contains((Object)operands.get(2).getOutputType());
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> operands) {
            String str = operands.get(0).getString();
            int from = operands.get(1).getInteger();
            if (from < 0) {
                from = from + str.length() + 1;
            }
            if (operands.size() == 3) {
                int length = operands.get(2).getInteger();
                return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.substring(str, from, length));
            }
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, SqlFunctions.substring(str, from));
        }
    };

    private static String trim(boolean leading, boolean trailing, String removeChars, String fromStr) {
        int j = fromStr.length();
        if (trailing) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (removeChars.indexOf(fromStr.charAt(j - 1)) < 0) break;
                --j;
            }
        }
        int i = 0;
        if (leading) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (removeChars.indexOf(fromStr.charAt(i)) < 0) break;
                ++i;
            }
        }
        return fromStr.substring(i, j);
    }

    @FunctionalInterface
    private static interface StringUnaryOperator
    extends BeamSqlUnaryOperator {
        @Override
        default public boolean accept(BeamSqlExpression arg) {
            return SqlTypeName.CHAR_TYPES.contains((Object)arg.getOutputType());
        }

        @Override
        default public SqlTypeName getOutputType() {
            return SqlTypeName.VARCHAR;
        }
    }

    public static interface StringOperator
    extends BeamSqlOperator {
        @Override
        default public SqlTypeName getOutputType() {
            return SqlTypeName.VARCHAR;
        }
    }
}

