/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.NlsString;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.ReadableInstant;

public class BeamSqlPrimitive<T>
extends BeamSqlExpression {
    private T value;

    private BeamSqlPrimitive() {
    }

    private BeamSqlPrimitive(T value, SqlTypeName typeName) {
        this.outputType = typeName;
        this.value = value;
        if (!this.accept()) {
            throw new IllegalArgumentException(String.format("value [%s] doesn't match type [%s].", new Object[]{value, this.outputType}));
        }
    }

    private BeamSqlPrimitive(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    public static <T> BeamSqlPrimitive<T> of(SqlTypeName outputType, T value) {
        return new BeamSqlPrimitive<T>(value, outputType);
    }

    @Override
    public SqlTypeName getOutputType() {
        return this.outputType;
    }

    public T getValue() {
        return this.value;
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return (Double)this.getValue();
    }

    public float getFloat() {
        return ((Float)this.getValue()).floatValue();
    }

    public int getInteger() {
        return (Integer)this.getValue();
    }

    public short getShort() {
        return (Short)this.getValue();
    }

    public byte getByte() {
        return (Byte)this.getValue();
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public ReadableInstant getDate() {
        return (ReadableInstant)this.getValue();
    }

    public BigDecimal getDecimal() {
        return (BigDecimal)this.getValue();
    }

    @Override
    public boolean accept() {
        if (this.value == null) {
            return true;
        }
        switch (this.outputType) {
            case BIGINT: {
                return this.value instanceof Long;
            }
            case DECIMAL: {
                return this.value instanceof BigDecimal;
            }
            case DOUBLE: {
                return this.value instanceof Double;
            }
            case FLOAT: {
                return this.value instanceof Float;
            }
            case INTEGER: {
                return this.value instanceof Integer;
            }
            case SMALLINT: {
                return this.value instanceof Short;
            }
            case TINYINT: {
                return this.value instanceof Byte;
            }
            case BOOLEAN: {
                return this.value instanceof Boolean;
            }
            case CHAR: 
            case VARCHAR: {
                return this.value instanceof String || this.value instanceof NlsString;
            }
            case VARBINARY: {
                return this.value instanceof byte[] || this.value instanceof ByteString;
            }
            case TIME: 
            case TIMESTAMP: 
            case DATE: {
                return this.value instanceof ReadableInstant;
            }
            case INTERVAL_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_HOUR: 
            case INTERVAL_DAY: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR: {
                return this.value instanceof BigDecimal;
            }
            case SYMBOL: {
                return true;
            }
            case ARRAY: {
                return this.value instanceof List;
            }
            case MAP: {
                return this.value instanceof Map;
            }
            case ROW: {
                return this.value instanceof Row;
            }
            case MULTISET: {
                return this.value instanceof Iterable;
            }
        }
        throw new UnsupportedOperationException("Unsupported Beam SQL type in expression: " + this.outputType.name());
    }

    @Override
    public BeamSqlPrimitive<T> evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).add("outputType", (Object)this.outputType).toString();
    }
}

