/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlOperator;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlOperatorExpression
extends BeamSqlExpression {
    private final BeamSqlOperator operator;

    public BeamSqlOperatorExpression(BeamSqlOperator operator, List<BeamSqlExpression> operands) {
        super(operands, operator.getOutputType());
        this.operator = operator;
    }

    @Override
    public boolean accept() {
        return this.operator.accept(this.operands);
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        List<BeamSqlPrimitive> arguments = this.operands.stream().map(operand -> operand.evaluate(inputRow, window, env)).collect(Collectors.toList());
        return this.operator.apply(arguments);
    }
}

