/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlDotExpression
extends BeamSqlExpression {
    public BeamSqlDotExpression(List<BeamSqlExpression> operands, SqlTypeName sqlTypeName) {
        super(operands, sqlTypeName);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && SqlTypeName.ROW.equals((Object)((BeamSqlExpression)this.operands.get(0)).getOutputType()) && (SqlTypeName.VARCHAR.equals((Object)((BeamSqlExpression)this.operands.get(1)).getOutputType()) || SqlTypeName.CHAR.equals((Object)((BeamSqlExpression)this.operands.get(1)).getOutputType()));
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        Row dynamicRow = (Row)this.opValueEvaluated(0, inputRow, window, env);
        String fieldName = (String)this.opValueEvaluated(1, inputRow, window, env);
        SqlTypeName fieldType = this.getFieldType(dynamicRow, fieldName);
        return BeamSqlPrimitive.of(fieldType, dynamicRow.getValue(fieldName));
    }

    private SqlTypeName getFieldType(Row row, String fieldName) {
        Schema.Field field = row.getSchema().getField(fieldName);
        return CalciteUtils.toSqlTypeName(field.getType());
    }
}

