/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlTimestampAddFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.InferTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.OperandTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlDatetimePlusOperator
extends SqlSpecialOperator {
    SqlDatetimePlusOperator() {
        super("+", SqlKind.PLUS, 40, true, ReturnTypes.ARG2_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.MINUS_DATE_OPERATOR);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType leftType = opBinding.getOperandType(0);
        IntervalSqlType unitType = (IntervalSqlType)opBinding.getOperandType(1);
        TimeUnit timeUnit = unitType.getIntervalQualifier().getStartUnit();
        return SqlTimestampAddFunction.deduceType(typeFactory, timeUnit, unitType, leftType);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.getDialect().unparseSqlDatetimeArithmetic(writer, call, SqlKind.PLUS, leftPrec, rightPrec);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return SqlStdOperatorTable.PLUS.getMonotonicity(call);
    }
}

