/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;

public class PostgresqlSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new PostgresqlSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.POSTGRESQL).withIdentifierQuoteString("\""));

    public PostgresqlSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public SqlNode getCastSpec(RelDataType type) {
        String castSpec;
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                castSpec = "_smallint";
                break;
            }
            case DOUBLE: {
                castSpec = "_double precision";
                break;
            }
            default: {
                return super.getCastSpec(type);
            }
        }
        return new SqlDataTypeSpec(new SqlIdentifier(castSpec, SqlParserPos.ZERO), -1, -1, null, null, SqlParserPos.ZERO);
    }

    @Override
    protected boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

