/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Ord;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWindow;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.OperandTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlVisitor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;

public class SqlOverOperator
extends SqlBinaryOperator {
    public SqlOverOperator() {
        super("OVER", SqlKind.OVER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.overNonAggregate());
        }
        Object window = call.operand(1);
        validator.validateWindow((SqlNode)window, scope, aggCall);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        Object agg = call.operand(0);
        if (!(agg instanceof SqlCall)) {
            throw new IllegalStateException("Argument to SqlOverOperator should be SqlCall, got " + agg.getClass() + ": " + agg);
        }
        Object window = call.operand(1);
        SqlWindow w = validator.resolveWindow((SqlNode)window, scope, false);
        final int groupCount = w.isAlwaysNonEmpty() ? 1 : 0;
        SqlCall aggCall = (SqlCall)agg;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            @Override
            public int getGroupCount() {
                return groupCount;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        ((SqlValidatorImpl)validator).setValidatedNodeType(call, ret);
        ((SqlValidatorImpl)validator).setValidatedNodeType((SqlNode)agg, ret);
        return ret;
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
                if (operand == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                argHandler.visitChild(visitor, call, operand.i, (SqlNode)operand.e);
            }
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }
}

