/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSetOption;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUseCatalog
extends SqlSetOption
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqlUseCatalog.class);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogName;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("USE CATALOG", SqlKind.OTHER);

    public SqlUseCatalog(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized String scope, @UnknownKeyFor @NonNull @Initialized SqlNode catalogName) {
        super(pos, scope, SqlDdlNodes.getIdentifier(catalogName, pos), null);
        this.catalogName = SqlDdlNodes.getIdentifier(catalogName, pos);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized SqlOperator getOperator() {
        return OPERATOR;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return Collections.singletonList(this.catalogName);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.catalogName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        String name = (String)pair.right;
        if (!(schema instanceof BeamCalciteSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Schema is not of instance BeamCalciteSchema"));
        }
        BeamCalciteSchema beamCalciteSchema = (BeamCalciteSchema)schema;
        @Nullable CatalogManager catalogManager = beamCalciteSchema.getCatalogManager();
        if (catalogManager == null) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unexpected 'USE CATALOG' call for Schema '%s' that is not a Catalog.", name)));
        }
        if (catalogManager.getCatalog(name) == null) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Cannot use catalog: '%s' not found.", name)));
        }
        if (catalogManager.currentCatalog().name().equals(name)) {
            LOG.info("Catalog '{}' is already in use.", (Object)name);
            return;
        }
        catalogManager.useCatalog(name);
        LOG.info("Switched to catalog '{}' (type: {})", (Object)name, (Object)catalogManager.currentCatalog().type());
    }
}

