/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDropDatabase
extends SqlDrop
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqlDropDatabase.class);
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("DROP DATABASE", SqlKind.OTHER_DDL);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName;
    private final @UnknownKeyFor @NonNull @Initialized boolean cascade;

    public SqlDropDatabase(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean ifExists, @UnknownKeyFor @NonNull @Initialized SqlNode databaseName, @UnknownKeyFor @NonNull @Initialized boolean cascade) {
        super(OPERATOR, pos, ifExists);
        this.databaseName = SqlDdlNodes.getIdentifier(databaseName, pos);
        this.cascade = cascade;
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        if (this.cascade) {
            writer.keyword("CASCADE");
        } else {
            writer.keyword("RESTRICT");
        }
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        block6: {
            Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.databaseName);
            Schema schema = ((CalciteSchema)pair.left).schema;
            String name = (String)pair.right;
            if (!(schema instanceof BeamCalciteSchema)) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Schema is not of instance BeamCalciteSchema"));
            }
            BeamCalciteSchema beamCalciteSchema = (BeamCalciteSchema)schema;
            @Nullable CatalogManager catalogManager = beamCalciteSchema.getCatalogManager();
            if (catalogManager == null) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unexpected 'DROP DATABASE' call using Schema '%s' that is not a Catalog.", name)));
            }
            Catalog catalog = catalogManager.currentCatalog();
            try {
                LOG.info("Dropping database '{}'", (Object)name);
                boolean dropped = catalog.dropDatabase(name, this.cascade);
                if (dropped) {
                    LOG.info("Successfully dropped database '{}'", (Object)name);
                    break block6;
                }
                if (this.ifExists) {
                    LOG.info("Database '{}' does not exist.", (Object)name);
                    break block6;
                }
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Database '%s' does not exist.", name)));
            }
            catch (Exception e) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Encountered an error when dropping database '%s': %s", name, e)));
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.databaseName);
    }
}

