/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCreateDatabase
extends SqlCreate
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqlCreateDatabase.class);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("CREATE DATABASE", SqlKind.OTHER_DDL);

    public SqlCreateDatabase(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean replace, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists, @UnknownKeyFor @NonNull @Initialized SqlNode databaseName) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.databaseName = SqlDdlNodes.getIdentifier(databaseName, pos);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        ImmutableList.Builder operands = ImmutableList.builder();
        operands.add((Object)this.databaseName);
        return operands.build();
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("DATABASE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        block6: {
            Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.databaseName);
            Schema schema = ((CalciteSchema)pair.left).schema;
            String name = (String)pair.right;
            if (!(schema instanceof BeamCalciteSchema)) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Schema is not of instance BeamCalciteSchema"));
            }
            @Nullable CatalogManager catalogManager = ((BeamCalciteSchema)schema).getCatalogManager();
            if (catalogManager == null) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unexpected 'CREATE DATABASE' call using Schema '%s' that is not a Catalog.", name)));
            }
            Catalog catalog = catalogManager.currentCatalog();
            try {
                LOG.info("Creating database '{}'", (Object)name);
                boolean created = catalog.createDatabase(name);
                if (created) {
                    LOG.info("Successfully created database '{}'", (Object)name);
                    break block6;
                }
                if (this.ifNotExists) {
                    LOG.info("Database '{}' already exists.", (Object)name);
                    break block6;
                }
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Database '%s' already exists.", name)));
            }
            catch (Exception e) {
                throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Encountered an error when creating database '%s': %s", name, e)));
            }
        }
    }
}

