/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;

public class BeamUncollectRel
extends Uncollect
implements BeamRelNode {
    public BeamUncollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        super(cluster, traitSet, input, withOrdinality);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new BeamUncollectRel(this.getCluster(), traitSet, input, this.withOrdinality);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static class UncollectDoFn
    extends DoFn<Row, Row> {
        private final Schema schema;

        private UncollectDoFn(Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row inputRow, DoFn.OutputReceiver<Row> output) {
            for (Object element : inputRow.getArray(0)) {
                output.output((Object)Row.withSchema((Schema)this.schema).addValue(element).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument(pinput.size() == 1, "Wrong number of inputs for %s: %s", (Object)BeamUncollectRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toBeamSchema(BeamUncollectRel.this.getRowType());
            PCollection uncollected = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new UncollectDoFn(outputSchema)))).setCoder((Coder)outputSchema.getRowCoder());
            return uncollected;
        }
    }
}

