/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.row;

import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlFieldAccessExpression
extends BeamSqlExpression {
    private BeamSqlExpression referenceExpression;
    private int nestedFieldIndex;

    public BeamSqlFieldAccessExpression(BeamSqlExpression referenceExpression, int nestedFieldIndex, SqlTypeName nestedFieldType) {
        super(Collections.emptyList(), nestedFieldType);
        this.referenceExpression = referenceExpression;
        this.nestedFieldIndex = nestedFieldIndex;
    }

    @Override
    public boolean accept() {
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        Object targetFieldValue;
        BeamSqlPrimitive targetObject = this.referenceExpression.evaluate(inputRow, window, env);
        SqlTypeName targetFieldType = targetObject.getOutputType();
        if (SqlTypeName.ARRAY.equals((Object)targetFieldType)) {
            targetFieldValue = ((List)targetObject.getValue()).get(this.nestedFieldIndex);
        } else if (SqlTypeName.ROW.equals((Object)targetFieldType)) {
            targetFieldValue = ((Row)targetObject.getValue()).getValue(this.nestedFieldIndex);
        } else {
            throw new IllegalArgumentException("Attempt to access field of unsupported type " + targetFieldType.getDeclaringClass().getSimpleName() + ". Field access operator is only supported for arrays or rows");
        }
        return BeamSqlPrimitive.of(this.outputType, targetFieldValue);
    }
}

