/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util;

import java.math.BigDecimal;

public enum TimeUnit {
    YEAR(true, ' ', BigDecimal.valueOf(12L), null),
    MONTH(true, '-', BigDecimal.ONE, BigDecimal.valueOf(12L)),
    DAY(false, '-', BigDecimal.valueOf(86400000L), null),
    HOUR(false, ' ', BigDecimal.valueOf(3600000L), BigDecimal.valueOf(24L)),
    MINUTE(false, ':', BigDecimal.valueOf(60000L), BigDecimal.valueOf(60L)),
    SECOND(false, ':', BigDecimal.valueOf(1000L), BigDecimal.valueOf(60L)),
    QUARTER(true, '*', BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)),
    WEEK(false, '*', BigDecimal.valueOf(604800000L), BigDecimal.valueOf(53L)),
    MILLISECOND(false, '.', BigDecimal.ONE, BigDecimal.valueOf(1000L)),
    MICROSECOND(false, '.', BigDecimal.ONE.scaleByPowerOfTen(-3), BigDecimal.valueOf(1000000L)),
    DOW(false, '-', null, null),
    DOY(false, '-', null, null),
    EPOCH(false, '*', null, null),
    DECADE(true, '*', BigDecimal.valueOf(120L), null),
    CENTURY(true, '*', BigDecimal.valueOf(1200L), null),
    MILLENNIUM(true, '*', BigDecimal.valueOf(12000L), null);

    public final boolean yearMonth;
    public final char separator;
    public final BigDecimal multiplier;
    private final BigDecimal limit;
    private static final TimeUnit[] CACHED_VALUES;

    private TimeUnit(boolean yearMonth, char separator, BigDecimal multiplier, BigDecimal limit) {
        this.yearMonth = yearMonth;
        this.separator = separator;
        this.multiplier = multiplier;
        this.limit = limit;
    }

    public static TimeUnit getValue(int ordinal) {
        return ordinal < 0 || ordinal >= CACHED_VALUES.length ? null : CACHED_VALUES[ordinal];
    }

    public boolean isValidValue(BigDecimal field) {
        return field.compareTo(BigDecimal.ZERO) >= 0 && (this.limit == null || field.compareTo(this.limit) < 0);
    }

    static {
        CACHED_VALUES = TimeUnit.values();
    }
}

