/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorUtil;

public interface EnumerableRel
extends RelNode {
    public static final RelFactories.FilterFactory FILTER_FACTORY = new RelFactories.FilterFactory(){

        @Override
        public RelNode createFilter(RelNode child, RexNode condition) {
            return EnumerableFilter.create(child, condition);
        }
    };
    public static final RelFactories.ProjectFactory PROJECT_FACTORY = new RelFactories.ProjectFactory(){

        @Override
        public RelNode createProject(RelNode child, List<? extends RexNode> projects, List<String> fieldNames) {
            RelOptCluster cluster = child.getCluster();
            RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames, SqlValidatorUtil.F_SUGGESTER);
            return EnumerableProject.create(child, projects, rowType);
        }
    };

    public Result implement(EnumerableRelImplementor var1, Prefer var2);

    public static class Result {
        public final BlockStatement block;
        public final PhysType physType;
        public final JavaRowFormat format;

        public Result(BlockStatement block, PhysType physType, JavaRowFormat format) {
            this.block = block;
            this.physType = physType;
            this.format = format;
        }
    }

    public static enum Prefer {
        ARRAY,
        ARRAY_NICE,
        CUSTOM,
        CUSTOM_NICE,
        ANY;


        public JavaRowFormat preferCustom() {
            return this.prefer(JavaRowFormat.CUSTOM);
        }

        public JavaRowFormat preferArray() {
            return this.prefer(JavaRowFormat.ARRAY);
        }

        public JavaRowFormat prefer(JavaRowFormat format) {
            switch (this) {
                case CUSTOM: {
                    return JavaRowFormat.CUSTOM;
                }
                case ARRAY: {
                    return JavaRowFormat.ARRAY;
                }
            }
            return format;
        }

        public Prefer of(JavaRowFormat format) {
            switch (format) {
                case ARRAY: {
                    return ARRAY;
                }
            }
            return CUSTOM;
        }
    }
}

