/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOSinkRule;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.RenameFields;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamIOSinkRel
extends TableModify
implements BeamRelNode,
RelStructuredTypeFlattener.SelfFlatteningRel {
    private final @UnknownKeyFor @NonNull @Initialized BeamSqlTable sqlTable;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptions;
    private @UnknownKeyFor @NonNull @Initialized boolean isFlattening = false;

    public BeamIOSinkRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelOptTable table, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Prepare.CatalogReader catalogReader, @UnknownKeyFor @NonNull @Initialized RelNode child, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableModify.Operation operation, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> updateColumnList, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> sourceExpressionList, @UnknownKeyFor @NonNull @Initialized boolean flattened, @UnknownKeyFor @NonNull @Initialized BeamSqlTable sqlTable, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptions) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        this.sqlTable = sqlTable;
        this.pipelineOptions = pipelineOptions;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputEstimates = BeamSqlRelUtils.getNodeStats(this.input, mq);
        return BeamCostModel.FACTORY.makeCost(inputEstimates.getRowCount(), inputEstimates.getRate());
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        boolean flattened = this.isFlattened() || this.isFlattening;
        BeamIOSinkRel newRel = new BeamIOSinkRel(this.getCluster(), this.getTable(), this.getCatalogReader(), (RelNode)BeamIOSinkRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), flattened, this.sqlTable, this.pipelineOptions);
        newRel.traitSet = traitSet;
        return newRel;
    }

    public void flattenRel(@UnknownKeyFor @NonNull @Initialized RelStructuredTypeFlattener flattener) {
        this.isFlattening = true;
        flattener.rewriteGeneric((RelNode)this);
        this.isFlattening = false;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner) {
        planner.addRule((RelOptRule)BeamIOSinkRule.INSTANCE);
        super.register(planner);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamIOSinkRel.class.getSimpleName(), pinput);
            Schema schema = CalciteUtils.toSchema(BeamIOSinkRel.this.getExpectedInputRowType(0));
            PCollection input = ((PCollection)pinput.get(0).apply((PTransform)RenameFields.create())).setRowSchema(schema);
            BeamIOSinkRel.this.sqlTable.buildIOWriter((PCollection<Row>)input);
            return input;
        }
    }
}

