/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udf;

import com.google.auto.service.AutoService;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.sdk.extensions.sql.impl.udf.UDF;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={BeamBuiltinFunctionProvider.class})
public class IsNan
extends BeamBuiltinFunctionProvider {
    private static final @UnknownKeyFor @NonNull @Initialized String SQL_FUNCTION_NAME = "IS_NAN";

    @UDF(funcName="IS_NAN", parameterArray={Schema.TypeName.FLOAT}, returnType=Schema.TypeName.BOOLEAN)
    public @UnknownKeyFor @NonNull @Initialized Boolean isNan(@UnknownKeyFor @NonNull @Initialized Float value) {
        return Float.isNaN(value.floatValue());
    }

    @UDF(funcName="IS_NAN", parameterArray={Schema.TypeName.DOUBLE}, returnType=Schema.TypeName.BOOLEAN)
    public @UnknownKeyFor @NonNull @Initialized Boolean isNan(@UnknownKeyFor @NonNull @Initialized Double value) {
        return Double.isNaN(value);
    }
}

