/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.AutoValue_VarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class VarianceAccumulator
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized VarianceAccumulator EMPTY = VarianceAccumulator.newVarianceAccumulator(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);

    VarianceAccumulator() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal variance();

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal count();

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal sum();

    static @UnknownKeyFor @NonNull @Initialized VarianceAccumulator newVarianceAccumulator(@UnknownKeyFor @NonNull @Initialized BigDecimal variance, @UnknownKeyFor @NonNull @Initialized BigDecimal count, @UnknownKeyFor @NonNull @Initialized BigDecimal sum) {
        return new AutoValue_VarianceAccumulator(variance, count, sum);
    }

    static @UnknownKeyFor @NonNull @Initialized VarianceAccumulator ofZeroElements() {
        return EMPTY;
    }

    static @UnknownKeyFor @NonNull @Initialized VarianceAccumulator ofSingleElement(@UnknownKeyFor @NonNull @Initialized BigDecimal inputElement) {
        return VarianceAccumulator.newVarianceAccumulator(BigDecimal.ZERO, BigDecimal.ONE, inputElement);
    }

    @UnknownKeyFor @NonNull @Initialized VarianceAccumulator combineWith(@UnknownKeyFor @NonNull @Initialized VarianceAccumulator otherVariance) {
        if (EMPTY.equals(this)) {
            return otherVariance;
        }
        if (EMPTY.equals(otherVariance)) {
            return this;
        }
        BigDecimal increment = this.calculateIncrement(this, otherVariance);
        BigDecimal combinedVariance = this.variance().add(otherVariance.variance()).add(increment);
        return VarianceAccumulator.newVarianceAccumulator(combinedVariance, this.count().add(otherVariance.count()), this.sum().add(otherVariance.sum()));
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal calculateIncrement(@UnknownKeyFor @NonNull @Initialized VarianceAccumulator varianceX, @UnknownKeyFor @NonNull @Initialized VarianceAccumulator varianceY) {
        BigDecimal m = varianceX.count();
        BigDecimal n = varianceY.count();
        BigDecimal sumX = varianceX.sum();
        BigDecimal sumY = varianceY.sum();
        BigDecimal multiplier = m.divide(n.multiply(m.add(n)), VarianceFn.MATH_CTX);
        BigDecimal square = sumX.multiply(n).divide(m, VarianceFn.MATH_CTX).subtract(sumY).pow(2);
        return multiplier.multiply(square);
    }
}

