/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultSchema(value=JavaBeanSchema.class)
public class Customer
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized int id;
    private @UnknownKeyFor @NonNull @Initialized String name;
    private @UnknownKeyFor @NonNull @Initialized String countryOfResidence;

    public Customer(@UnknownKeyFor @NonNull @Initialized int id, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String countryOfResidence) {
        this.id = id;
        this.name = name;
        this.countryOfResidence = countryOfResidence;
    }

    public Customer() {
    }

    public @UnknownKeyFor @NonNull @Initialized int getId() {
        return this.id;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setId(@UnknownKeyFor @NonNull @Initialized int id) {
        this.id = id;
    }

    public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
        this.name = name;
    }

    public void setCountryOfResidence(@UnknownKeyFor @NonNull @Initialized String countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return this.id == customer.id && Objects.equals(this.name, customer.name) && Objects.equals(this.countryOfResidence, customer.countryOfResidence);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.id, this.name, this.countryOfResidence);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Customer{id=" + this.id + ", name='" + this.name + '\'' + ", countryOfResidence='" + this.countryOfResidence + '\'' + '}';
    }
}

