/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_SqlTransform
extends SqlTransform {
    private final String queryString;
    private final @Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer;
    private final List<String> ddlStrings;
    private final QueryPlanner.QueryParameters queryParameters;
    private final List<SqlTransform.UdfDefinition> udfDefinitions;
    private final List<SqlTransform.UdafDefinition> udafDefinitions;
    private final boolean autoLoading;
    private final Map<String, TableProvider> tableProviderMap;
    private final @Nullable String defaultTableProvider;
    private final @Nullable String queryPlannerClassName;

    private AutoValue_SqlTransform(String queryString, @Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer, List<String> ddlStrings, QueryPlanner.QueryParameters queryParameters, List<SqlTransform.UdfDefinition> udfDefinitions, List<SqlTransform.UdafDefinition> udafDefinitions, boolean autoLoading, Map<String, TableProvider> tableProviderMap, @Nullable String defaultTableProvider, @Nullable String queryPlannerClassName) {
        this.queryString = queryString;
        this.errorsTransformer = errorsTransformer;
        this.ddlStrings = ddlStrings;
        this.queryParameters = queryParameters;
        this.udfDefinitions = udfDefinitions;
        this.udafDefinitions = udafDefinitions;
        this.autoLoading = autoLoading;
        this.tableProviderMap = tableProviderMap;
        this.defaultTableProvider = defaultTableProvider;
        this.queryPlannerClassName = queryPlannerClassName;
    }

    @Override
    String queryString() {
        return this.queryString;
    }

    @Override
    @Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer() {
        return this.errorsTransformer;
    }

    @Override
    List<String> ddlStrings() {
        return this.ddlStrings;
    }

    @Override
    QueryPlanner.QueryParameters queryParameters() {
        return this.queryParameters;
    }

    @Override
    List<SqlTransform.UdfDefinition> udfDefinitions() {
        return this.udfDefinitions;
    }

    @Override
    List<SqlTransform.UdafDefinition> udafDefinitions() {
        return this.udafDefinitions;
    }

    @Override
    boolean autoLoading() {
        return this.autoLoading;
    }

    @Override
    Map<String, TableProvider> tableProviderMap() {
        return this.tableProviderMap;
    }

    @Override
    @Nullable String defaultTableProvider() {
        return this.defaultTableProvider;
    }

    @Override
    @Nullable String queryPlannerClassName() {
        return this.queryPlannerClassName;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqlTransform) {
            SqlTransform that = (SqlTransform)((Object)o);
            return this.queryString.equals(that.queryString()) && (this.errorsTransformer == null ? that.errorsTransformer() == null : this.errorsTransformer.equals(that.errorsTransformer())) && this.ddlStrings.equals(that.ddlStrings()) && this.queryParameters.equals(that.queryParameters()) && this.udfDefinitions.equals(that.udfDefinitions()) && this.udafDefinitions.equals(that.udafDefinitions()) && this.autoLoading == that.autoLoading() && this.tableProviderMap.equals(that.tableProviderMap()) && (this.defaultTableProvider == null ? that.defaultTableProvider() == null : this.defaultTableProvider.equals(that.defaultTableProvider())) && (this.queryPlannerClassName == null ? that.queryPlannerClassName() == null : this.queryPlannerClassName.equals(that.queryPlannerClassName()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorsTransformer == null ? 0 : this.errorsTransformer.hashCode();
        h$ *= 1000003;
        h$ ^= this.ddlStrings.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryParameters.hashCode();
        h$ *= 1000003;
        h$ ^= this.udfDefinitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.udafDefinitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoLoading ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.tableProviderMap.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultTableProvider == null ? 0 : this.defaultTableProvider.hashCode();
        h$ *= 1000003;
        return h$ ^= this.queryPlannerClassName == null ? 0 : this.queryPlannerClassName.hashCode();
    }

    @Override
    SqlTransform.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SqlTransform.Builder {
        private String queryString;
        private @Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer;
        private List<String> ddlStrings;
        private QueryPlanner.QueryParameters queryParameters;
        private List<SqlTransform.UdfDefinition> udfDefinitions;
        private List<SqlTransform.UdafDefinition> udafDefinitions;
        private Boolean autoLoading;
        private Map<String, TableProvider> tableProviderMap;
        private @Nullable String defaultTableProvider;
        private @Nullable String queryPlannerClassName;

        Builder() {
        }

        private Builder(SqlTransform source) {
            this.queryString = source.queryString();
            this.errorsTransformer = source.errorsTransformer();
            this.ddlStrings = source.ddlStrings();
            this.queryParameters = source.queryParameters();
            this.udfDefinitions = source.udfDefinitions();
            this.udafDefinitions = source.udafDefinitions();
            this.autoLoading = source.autoLoading();
            this.tableProviderMap = source.tableProviderMap();
            this.defaultTableProvider = source.defaultTableProvider();
            this.queryPlannerClassName = source.queryPlannerClassName();
        }

        @Override
        SqlTransform.Builder setQueryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        SqlTransform.Builder setErrorsTransformer(@Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer) {
            this.errorsTransformer = errorsTransformer;
            return this;
        }

        @Override
        SqlTransform.Builder setDdlStrings(List<String> ddlStrings) {
            if (ddlStrings == null) {
                throw new NullPointerException("Null ddlStrings");
            }
            this.ddlStrings = ddlStrings;
            return this;
        }

        @Override
        SqlTransform.Builder setQueryParameters(QueryPlanner.QueryParameters queryParameters) {
            if (queryParameters == null) {
                throw new NullPointerException("Null queryParameters");
            }
            this.queryParameters = queryParameters;
            return this;
        }

        @Override
        SqlTransform.Builder setUdfDefinitions(List<SqlTransform.UdfDefinition> udfDefinitions) {
            if (udfDefinitions == null) {
                throw new NullPointerException("Null udfDefinitions");
            }
            this.udfDefinitions = udfDefinitions;
            return this;
        }

        @Override
        SqlTransform.Builder setUdafDefinitions(List<SqlTransform.UdafDefinition> udafDefinitions) {
            if (udafDefinitions == null) {
                throw new NullPointerException("Null udafDefinitions");
            }
            this.udafDefinitions = udafDefinitions;
            return this;
        }

        @Override
        SqlTransform.Builder setAutoLoading(boolean autoLoading) {
            this.autoLoading = autoLoading;
            return this;
        }

        @Override
        SqlTransform.Builder setTableProviderMap(Map<String, TableProvider> tableProviderMap) {
            if (tableProviderMap == null) {
                throw new NullPointerException("Null tableProviderMap");
            }
            this.tableProviderMap = tableProviderMap;
            return this;
        }

        @Override
        SqlTransform.Builder setDefaultTableProvider(@Nullable String defaultTableProvider) {
            this.defaultTableProvider = defaultTableProvider;
            return this;
        }

        @Override
        SqlTransform.Builder setQueryPlannerClassName(@Nullable String queryPlannerClassName) {
            this.queryPlannerClassName = queryPlannerClassName;
            return this;
        }

        @Override
        SqlTransform build() {
            if (this.queryString == null || this.ddlStrings == null || this.queryParameters == null || this.udfDefinitions == null || this.udafDefinitions == null || this.autoLoading == null || this.tableProviderMap == null) {
                StringBuilder missing = new StringBuilder();
                if (this.queryString == null) {
                    missing.append(" queryString");
                }
                if (this.ddlStrings == null) {
                    missing.append(" ddlStrings");
                }
                if (this.queryParameters == null) {
                    missing.append(" queryParameters");
                }
                if (this.udfDefinitions == null) {
                    missing.append(" udfDefinitions");
                }
                if (this.udafDefinitions == null) {
                    missing.append(" udafDefinitions");
                }
                if (this.autoLoading == null) {
                    missing.append(" autoLoading");
                }
                if (this.tableProviderMap == null) {
                    missing.append(" tableProviderMap");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqlTransform(this.queryString, this.errorsTransformer, this.ddlStrings, this.queryParameters, this.udfDefinitions, this.udafDefinitions, this.autoLoading, this.tableProviderMap, this.defaultTableProvider, this.queryPlannerClassName);
        }
    }
}

