/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOWriter
extends PTransform<PCollection<Row>, POutput>
implements Serializable {
    private String filePattern;
    protected Schema schema;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOWriter(Schema schema, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.schema = schema;
        this.csvFormat = csvFormat;
    }

    public POutput expand(PCollection<Row> input) {
        return ((PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                Row row = (Row)ctx.element();
                ctx.output((Object)BeamTableUtils.beamRow2CsvLine(row, BeamTextCSVTableIOWriter.this.csvFormat));
            }
        }))).apply((PTransform)TextIO.write().to(this.filePattern));
    }
}

