/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamIOType;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@Experimental
public class BeamBigQueryTable
extends BaseBeamTable
implements Serializable {
    private String tableSpec;

    public BeamBigQueryTable(Schema beamSchema, String tableSpec) {
        super(beamSchema);
        this.tableSpec = tableSpec;
    }

    @Override
    public BeamIOType getSourceType() {
        return BeamIOType.BOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(Pipeline pipeline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PTransform<? super PCollection<Row>, POutput> buildIOWriter() {
        return new PTransform<PCollection<Row>, POutput>(){

            public WriteResult expand(PCollection<Row> input) {
                return (WriteResult)input.apply((PTransform)BigQueryIO.write().withSchema(BigQueryUtils.toTableSchema((Schema)BeamBigQueryTable.this.getSchema())).withFormatFunction(BigQueryUtils.toTableRow()).to(BeamBigQueryTable.this.tableSpec));
            }
        };
    }

    String getTableSpec() {
        return this.tableSpec;
    }
}

