/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamIOType;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

public class BeamPCollectionTable
extends BaseBeamTable {
    private BeamIOType ioType;
    private transient PCollection<Row> upstream;

    public BeamPCollectionTable(PCollection<Row> upstream) {
        super(((RowCoder)upstream.getCoder()).getSchema());
        this.ioType = upstream.isBounded().equals((Object)PCollection.IsBounded.BOUNDED) ? BeamIOType.BOUNDED : BeamIOType.UNBOUNDED;
        this.upstream = upstream;
    }

    @Override
    public BeamIOType getSourceType() {
        return this.ioType;
    }

    @Override
    public PCollection<Row> buildIOReader(Pipeline pipeline) {
        return this.upstream;
    }

    @Override
    public PTransform<? super PCollection<Row>, POutput> buildIOWriter() {
        throw new IllegalArgumentException("cannot use [BeamPCollectionTable] as target");
    }
}

