/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSetOperatorsTransforms;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;

public class BeamSetOperatorRelBase {
    private BeamRelNode beamRelNode;
    private List<RelNode> inputs;
    private boolean all;
    private OpType opType;

    public BeamSetOperatorRelBase(BeamRelNode beamRelNode, OpType opType, List<RelNode> inputs, boolean all) {
        this.beamRelNode = beamRelNode;
        this.opType = opType;
        this.inputs = inputs;
        this.all = all;
    }

    public PCollection<Row> buildBeamPipeline(PCollectionTuple inputPCollections) {
        WindowFn rightWindow;
        PCollection leftRows = (PCollection)inputPCollections.apply("left", BeamSqlRelUtils.getBeamRelInput(this.inputs.get(0)).toPTransform());
        PCollection rightRows = (PCollection)inputPCollections.apply("right", BeamSqlRelUtils.getBeamRelInput(this.inputs.get(1)).toPTransform());
        WindowFn leftWindow = leftRows.getWindowingStrategy().getWindowFn();
        if (!leftWindow.isCompatible(rightWindow = rightRows.getWindowingStrategy().getWindowFn())) {
            throw new IllegalArgumentException("inputs of " + this.opType + " have different window strategy: " + leftWindow + " VS " + rightWindow);
        }
        TupleTag leftTag = new TupleTag();
        TupleTag rightTag = new TupleTag();
        String stageName = BeamSqlRelUtils.getStageName(this.beamRelNode);
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)leftTag, (PCollection)((PCollection)leftRows.apply(stageName + "_CreateLeftIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn())))).and(rightTag, (PCollection)rightRows.apply(stageName + "_CreateRightIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn()))).apply((PTransform)CoGroupByKey.create());
        PCollection ret = (PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new BeamSetOperatorsTransforms.SetOperatorFilteringDoFn((TupleTag<Row>)leftTag, (TupleTag<Row>)rightTag, this.opType, this.all)));
        return ret;
    }

    public static enum OpType implements Serializable
    {
        UNION,
        INTERSECT,
        MINUS;

    }
}

