/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.Prepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOSinkRule;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;

public class BeamIOSinkRel
extends TableModify
implements BeamRelNode,
RelStructuredTypeFlattener.SelfFlatteningRel {
    private final BeamSqlTable sqlTable;
    private boolean isFlattening = false;

    public BeamIOSinkRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened, BeamSqlTable sqlTable) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        this.sqlTable = sqlTable;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        boolean flattened = this.isFlattened() || this.isFlattening;
        BeamIOSinkRel newRel = new BeamIOSinkRel(this.getCluster(), this.getTable(), this.getCatalogReader(), BeamIOSinkRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), flattened, this.sqlTable);
        newRel.traitSet = traitSet;
        return newRel;
    }

    @Override
    public void flattenRel(RelStructuredTypeFlattener flattener) {
        this.isFlattening = true;
        flattener.rewriteGeneric(this);
        this.isFlattening = false;
    }

    @Override
    public void register(RelOptPlanner planner) {
        planner.addRule(BeamIOSinkRule.INSTANCE);
        super.register(planner);
    }

    @Override
    public PTransform<PCollectionTuple, PCollection<Row>> toPTransform() {
        return new Transform();
    }

    private class Transform
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionTuple inputPCollections) {
            RelNode input = BeamIOSinkRel.this.getInput();
            String stageName = BeamSqlRelUtils.getStageName(BeamIOSinkRel.this);
            PCollection upstream = (PCollection)inputPCollections.apply(BeamSqlRelUtils.getBeamRelInput(input).toPTransform());
            upstream.apply(stageName, BeamIOSinkRel.this.sqlTable.buildIOWriter());
            return upstream;
        }
    }
}

