/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlSubstringExpression
extends BeamSqlExpression {
    public BeamSqlSubstringExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() < 2 || this.operands.size() > 3) {
            return false;
        }
        if (!SqlTypeName.CHAR_TYPES.contains((Object)this.opType(0)) || !SqlTypeName.INT_TYPES.contains((Object)this.opType(1))) {
            return false;
        }
        return this.operands.size() != 3 || SqlTypeName.INT_TYPES.contains((Object)this.opType(2));
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        String str = (String)this.opValueEvaluated(0, inputRow, window, correlateEnv);
        int idx = (Integer)this.opValueEvaluated(1, inputRow, window, correlateEnv);
        int startIdx = idx;
        if (startIdx > 0) {
            --startIdx;
        } else if (startIdx < 0) {
            startIdx += str.length();
        } else {
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, "");
        }
        if (this.operands.size() == 3) {
            int length = (Integer)this.opValueEvaluated(2, inputRow, window, correlateEnv);
            if (length < 0) {
                length = 0;
            }
            int endIdx = Math.min(startIdx + length, str.length());
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, str.substring(startIdx, endIdx));
        }
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, str.substring(startIdx));
    }
}

