/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Optional;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.SqlTypeUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlIntervalMultiplyExpression
extends BeamSqlExpression {
    public BeamSqlIntervalMultiplyExpression(List<BeamSqlExpression> operands) {
        super(operands, BeamSqlIntervalMultiplyExpression.deduceOutputType(operands));
    }

    private static SqlTypeName deduceOutputType(List<BeamSqlExpression> operands) {
        Optional<BeamSqlExpression> intervalOperand = SqlTypeUtils.findExpressionOfType(operands, SqlTypeName.INTERVAL_TYPES);
        return intervalOperand.isPresent() ? intervalOperand.get().getOutputType() : null;
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.INTEGER).isPresent() && SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.INTERVAL_TYPES).isPresent();
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        BeamSqlPrimitive intervalOperandPrimitive = SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.INTERVAL_TYPES).get().evaluate(inputRow, window, correlateEnv);
        SqlTypeName intervalOperandType = intervalOperandPrimitive.getOutputType();
        BeamSqlPrimitive integerOperandPrimitive = SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.INTEGER).get().evaluate(inputRow, window, correlateEnv);
        BigDecimal integerOperandValue = new BigDecimal(integerOperandPrimitive.getInteger());
        BigDecimal multiplicationResult = integerOperandValue.multiply(TimeUnitUtils.timeUnitInternalMultiplier(intervalOperandType));
        return BeamSqlPrimitive.of(this.outputType, multiplicationResult);
    }
}

